/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.builder.primitive;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PrimitiveAssertion
implements Assertion {
    protected QName name;
    protected boolean optional;

    public PrimitiveAssertion() {
        this(null);
    }

    public PrimitiveAssertion(QName n) {
        this(n, false);
    }

    public PrimitiveAssertion(QName n, boolean o) {
        this.name = n;
        this.optional = o;
    }

    public PrimitiveAssertion(Element element, PolicyConstants constants) {
        this.name = new QName(element.getNamespaceURI(), element.getLocalName());
        Attr attribute = element.getAttributeNodeNS(constants.getNamespace(), constants.getOptionalAttrName());
        if (attribute != null) {
            this.optional = Boolean.valueOf(attribute.getValue());
        }
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (policyComponent.getType() != 5) {
            return false;
        }
        return this.getName().equals(((Assertion)policyComponent).getName());
    }

    public short getType() {
        return 5;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean o) {
        this.optional = o;
    }

    public PolicyComponent normalize() {
        if (this.isOptional()) {
            Policy policy = new Policy();
            ExactlyOne exactlyOne = new ExactlyOne();
            All all = new All();
            all.addPolicyComponent((PolicyComponent)this.cloneMandatory());
            exactlyOne.addPolicyComponent((PolicyComponent)all);
            exactlyOne.addPolicyComponent((PolicyComponent)new All());
            policy.addPolicyComponent((PolicyComponent)exactlyOne);
            return policy;
        }
        return this.cloneMandatory();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
    }

    protected Assertion cloneMandatory() {
        return new PrimitiveAssertion(this.name, false);
    }
}

