/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.state.AbstractServiceEngineStateMachine;
import org.apache.cxf.jbi.se.state.ServiceEngineStateFactory;
import org.apache.cxf.jbi.se.state.ServiceEngineStateMachine;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class CXFServiceEngine
implements ComponentLifeCycle,
Component {
    public static final String JBI_TRANSPORT_ID = "http://cxf.apache.org/transports/jbi";
    private static final Logger LOG = LogUtils.getL7dLogger(CXFServiceEngine.class);
    private ServiceEngineStateFactory stateFactory = ServiceEngineStateFactory.getInstance();

    public CXFServiceEngine() {
        this.stateFactory.setCurrentState(this.stateFactory.getShutdownState());
    }

    public final ObjectName getExtensionMBeanName() {
        return null;
    }

    public final void shutDown() throws JBIException {
        try {
            LOG.info(new Message("SE.SHUTDOWN", LOG, new Object[0]).toString());
            this.stateFactory.getCurrentState().changeState(ServiceEngineStateMachine.SEOperation.shutdown, null);
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            throw new JBIException(ex);
        }
    }

    public final void init(ComponentContext componentContext) throws JBIException {
        try {
            this.stateFactory.getCurrentState().changeState(ServiceEngineStateMachine.SEOperation.init, componentContext);
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, new Message("SE.FAILED.INIT.BUS", LOG, new Object[0]).toString(), ex);
            throw new JBIException(ex);
        }
    }

    public final void start() throws JBIException {
        try {
            LOG.info(new Message("SE.STARTUP", LOG, new Object[0]).toString());
            this.stateFactory.getCurrentState().changeState(ServiceEngineStateMachine.SEOperation.start, null);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            throw new JBIException((Throwable)ex);
        }
    }

    public final void stop() throws JBIException {
        try {
            LOG.info(new Message("SE.STOP", LOG, new Object[0]).toString());
            this.stateFactory.getCurrentState().changeState(ServiceEngineStateMachine.SEOperation.stop, null);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            throw new JBIException((Throwable)ex);
        }
    }

    public final ComponentLifeCycle getLifeCycle() {
        LOG.fine("CXFServiceEngine returning life cycle");
        return this;
    }

    public final ServiceUnitManager getServiceUnitManager() {
        LOG.fine("CXFServiceEngine return service unit manager");
        return AbstractServiceEngineStateMachine.getSUManager();
    }

    public final Document getServiceDescription(ServiceEndpoint serviceEndpoint) {
        Document doc = AbstractServiceEngineStateMachine.getSUManager().getServiceDescription(serviceEndpoint);
        LOG.fine("CXFServiceEngine returning service description: " + doc);
        return doc;
    }

    public final boolean isExchangeWithConsumerOkay(ServiceEndpoint ep, MessageExchange exchg) {
        LOG.fine("isExchangeWithConsumerOkay: endpoint: " + ep + " exchange: " + exchg);
        return true;
    }

    public final boolean isExchangeWithProviderOkay(ServiceEndpoint ep, MessageExchange exchng) {
        LOG.fine("isExchangeWithConsumerOkay: endpoint: " + ep + " exchange: " + exchng);
        return true;
    }

    public final ServiceEndpoint resolveEndpointReference(DocumentFragment documentFragment) {
        return null;
    }
}

