/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(LocalDestination.class);
    private LocalTransportFactory localDestinationFactory;

    public LocalDestination(LocalTransportFactory localDestinationFactory, EndpointReferenceType epr, EndpointInfo ei) {
        super(epr, ei);
        this.localDestinationFactory = localDestinationFactory;
    }

    public void shutdown() {
        this.localDestinationFactory.remove(this);
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        Conduit conduit = (Conduit)inMessage.get((Object)LocalConduit.IN_CONDUIT);
        if (conduit instanceof LocalConduit) {
            return new SynchronousConduit((LocalConduit)conduit);
        }
        return null;
    }

    class SynchronousConduit
    extends AbstractConduit {
        private LocalConduit conduit;

        public SynchronousConduit(LocalConduit conduit) {
            super(null);
            this.conduit = conduit;
        }

        public void prepare(final Message message) throws IOException {
            if (!Boolean.TRUE.equals(message.getExchange().get((Object)LocalConduit.DIRECT_DISPATCH))) {
                final Exchange exchange = (Exchange)message.getExchange().get((Object)LocalConduit.IN_EXCHANGE);
                AbstractWrappedOutputStream cout = new AbstractWrappedOutputStream(){

                    protected void onFirstWrite() throws IOException {
                        final PipedInputStream stream = new PipedInputStream();
                        this.wrappedStream = new PipedOutputStream(stream);
                        Runnable receiver = new Runnable(){

                            public void run() {
                                MessageImpl m = new MessageImpl();
                                LocalDestination.this.localDestinationFactory.copy(message, (Message)m);
                                if (exchange != null) {
                                    exchange.setInMessage((Message)m);
                                }
                                m.setContent(InputStream.class, (Object)stream);
                                SynchronousConduit.this.conduit.getMessageObserver().onMessage((Message)m);
                            }
                        };
                        new Thread(receiver).start();
                    }
                };
                message.setContent(OutputStream.class, (Object)cout);
            } else {
                CachedOutputStream stream = new CachedOutputStream();
                message.setContent(OutputStream.class, (Object)stream);
            }
        }

        public void close(Message message) throws IOException {
            if (Boolean.TRUE.equals(message.getExchange().get((Object)LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get((Object)LocalConduit.IN_EXCHANGE);
                MessageImpl copy = new MessageImpl();
                copy.putAll((Map)message);
                MessageImpl.copyContent((Message)message, (Message)copy);
                CachedOutputStream stream = (CachedOutputStream)message.getContent(OutputStream.class);
                copy.setContent(InputStream.class, (Object)stream.getInputStream());
                if (exchange != null && exchange.getInMessage() == null) {
                    exchange.setInMessage((Message)copy);
                }
                this.conduit.getMessageObserver().onMessage((Message)copy);
                return;
            }
            super.close(message);
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

