/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container;

import com.iona.cxf.container.ApplicationState;
import com.iona.cxf.container.ContainerException;
import com.iona.cxf.container.classloader.ApplicationClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static final Logger LOG = LogUtils.getL7dLogger(Application.class);
    private static final String SPRING_CONFIG_DIR = "META-INF/spring";
    private static final String XML_FILE_SUFFIX = ".xml";
    private Bus bus;
    private File appDir;
    private String appName;
    private ClassLoader loader;
    private ApplicationState state;

    public Application(String name, File dir) throws ContainerException {
        this.appName = name;
        this.appDir = dir;
        this.state = ApplicationState.STOPPED;
    }

    public File getApplicationDirectory() {
        return this.appDir;
    }

    public String getName() {
        return this.appName;
    }

    public Set<QName> getServices() {
        ServerRegistry registry;
        HashSet<QName> services = new HashSet<QName>();
        if (this.bus != null && (registry = (ServerRegistry)this.bus.getExtension(ServerRegistry.class)) != null) {
            for (Server server : registry.getServers()) {
                services.add(server.getEndpoint().getService().getName());
            }
        }
        return services;
    }

    public synchronized void start() throws ContainerException {
        this.changeState(Event.START);
    }

    public synchronized void stop() throws ContainerException {
        this.changeState(Event.STOP);
    }

    public ApplicationState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(Event event) throws ContainerException {
        switch (event) {
            case STOP: {
                if (this.state != ApplicationState.STARTED) break;
                try {
                    this.cleanup();
                    break;
                }
                finally {
                    this.state = ApplicationState.STOPPED;
                }
            }
            case START: {
                if (this.state != ApplicationState.STOPPED && this.state != ApplicationState.FAILED) break;
                try {
                    this.init();
                    this.state = ApplicationState.STARTED;
                    break;
                }
                catch (ContainerException cex) {
                    this.state = ApplicationState.FAILED;
                    this.cleanup();
                    throw cex;
                }
            }
        }
    }

    private void init() throws ContainerException {
        block9: {
            ClassLoader orig = Thread.currentThread().getContextClassLoader();
            try {
                this.loader = ApplicationClassLoader.createClassLoader(this.appDir);
                Thread.currentThread().setContextClassLoader(this.loader);
                SpringBusFactory bf = new SpringBusFactory();
                File springConfDir = new File(this.appDir, SPRING_CONFIG_DIR);
                File[] files = springConfDir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(Application.XML_FILE_SUFFIX);
                    }
                });
                if (null != files) {
                    if (files.length > 1) {
                        throw new ContainerException(new Message("TOO_MANY_SPRING_BEAN_DEFINITIONS", LOG, new Object[0]));
                    }
                    if (files.length < 1) {
                        throw new ContainerException(new Message("MISSING_SPRING_BEAN_DEFINITIONS", LOG, new Object[0]));
                    }
                    String res = "spring/" + files[0].getName();
                    this.bus = bf.createBus(res);
                    break block9;
                }
                throw new ContainerException(new Message("MISSING_SPRING_BEAN_DEFINITIONS", LOG, new Object[0]));
            }
            catch (ContainerException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ContainerException(ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(orig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.loader);
            if (this.bus != null) {
                this.bus.shutdown(true);
            }
        }
        finally {
            this.bus = null;
            this.loader = null;
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Event {
        START,
        STOP;

    }
}

