/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomMapEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PatternEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URIEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.util.ClassUtils;

public class PropertyEditorRegistrySupport
implements PropertyEditorRegistry {
    private boolean defaultEditorsActive = false;
    private boolean configValueEditorsActive = false;
    private boolean propertySpecificEditorsRegistered = false;
    private Map defaultEditors;
    private Map customEditors;
    private Set sharedEditors;
    private Map customEditorCache;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class array$Lorg$springframework$core$io$Resource;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$util$regex$Pattern;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected void registerDefaultEditors() {
        this.defaultEditorsActive = true;
    }

    public void useConfigValueEditors() {
        this.configValueEditorsActive = true;
    }

    protected PropertyEditor getDefaultEditor(Class requiredType) {
        if (!this.defaultEditorsActive) {
            return null;
        }
        if (this.defaultEditors == null) {
            this.doRegisterDefaultEditors();
        }
        return (PropertyEditor)this.defaultEditors.get(requiredType);
    }

    private void doRegisterDefaultEditors() {
        this.defaultEditors = new HashMap(64);
        this.defaultEditors.put(class$java$lang$Class == null ? (class$java$lang$Class = PropertyEditorRegistrySupport.class$("java.lang.Class")) : class$java$lang$Class, new ClassEditor());
        this.defaultEditors.put(array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = PropertyEditorRegistrySupport.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class, new ClassArrayEditor());
        this.defaultEditors.put(class$java$io$File == null ? (class$java$io$File = PropertyEditorRegistrySupport.class$("java.io.File")) : class$java$io$File, new FileEditor());
        this.defaultEditors.put(class$java$io$InputStream == null ? (class$java$io$InputStream = PropertyEditorRegistrySupport.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor());
        this.defaultEditors.put(class$java$util$Locale == null ? (class$java$util$Locale = PropertyEditorRegistrySupport.class$("java.util.Locale")) : class$java$util$Locale, new LocaleEditor());
        this.defaultEditors.put(class$java$util$Properties == null ? (class$java$util$Properties = PropertyEditorRegistrySupport.class$("java.util.Properties")) : class$java$util$Properties, new PropertiesEditor());
        this.defaultEditors.put(array$Lorg$springframework$core$io$Resource == null ? (array$Lorg$springframework$core$io$Resource = PropertyEditorRegistrySupport.class$("[Lorg.springframework.core.io.Resource;")) : array$Lorg$springframework$core$io$Resource, new ResourceArrayPropertyEditor());
        this.defaultEditors.put(class$java$net$URL == null ? (class$java$net$URL = PropertyEditorRegistrySupport.class$("java.net.URL")) : class$java$net$URL, new URLEditor());
        if (JdkVersion.isAtLeastJava14()) {
            this.defaultEditors.put(class$java$net$URI == null ? (class$java$net$URI = PropertyEditorRegistrySupport.class$("java.net.URI")) : class$java$net$URI, new URIEditor());
            this.defaultEditors.put(class$java$util$regex$Pattern == null ? (class$java$util$regex$Pattern = PropertyEditorRegistrySupport.class$("java.util.regex.Pattern")) : class$java$util$regex$Pattern, new PatternEditor());
        }
        this.defaultEditors.put(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection, new CustomCollectionEditor(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection));
        this.defaultEditors.put(class$java$util$Set == null ? (class$java$util$Set = PropertyEditorRegistrySupport.class$("java.util.Set")) : class$java$util$Set, new CustomCollectionEditor(class$java$util$Set == null ? (class$java$util$Set = PropertyEditorRegistrySupport.class$("java.util.Set")) : class$java$util$Set));
        this.defaultEditors.put(class$java$util$SortedSet == null ? (class$java$util$SortedSet = PropertyEditorRegistrySupport.class$("java.util.SortedSet")) : class$java$util$SortedSet, new CustomCollectionEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = PropertyEditorRegistrySupport.class$("java.util.SortedSet")) : class$java$util$SortedSet));
        this.defaultEditors.put(class$java$util$List == null ? (class$java$util$List = PropertyEditorRegistrySupport.class$("java.util.List")) : class$java$util$List, new CustomCollectionEditor(class$java$util$List == null ? (class$java$util$List = PropertyEditorRegistrySupport.class$("java.util.List")) : class$java$util$List));
        this.defaultEditors.put(class$java$util$SortedMap == null ? (class$java$util$SortedMap = PropertyEditorRegistrySupport.class$("java.util.SortedMap")) : class$java$util$SortedMap, new CustomMapEditor(class$java$util$SortedMap == null ? (class$java$util$SortedMap = PropertyEditorRegistrySupport.class$("java.util.SortedMap")) : class$java$util$SortedMap));
        this.defaultEditors.put(array$B == null ? (array$B = PropertyEditorRegistrySupport.class$("[B")) : array$B, new ByteArrayPropertyEditor());
        this.defaultEditors.put(array$C == null ? (array$C = PropertyEditorRegistrySupport.class$("[C")) : array$C, new CharArrayPropertyEditor());
        this.defaultEditors.put(Character.TYPE, new CharacterEditor(false));
        this.defaultEditors.put(class$java$lang$Character == null ? (class$java$lang$Character = PropertyEditorRegistrySupport.class$("java.lang.Character")) : class$java$lang$Character, new CharacterEditor(true));
        this.defaultEditors.put(Boolean.TYPE, new CustomBooleanEditor(false));
        this.defaultEditors.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyEditorRegistrySupport.class$("java.lang.Boolean")) : class$java$lang$Boolean, new CustomBooleanEditor(true));
        this.defaultEditors.put(Byte.TYPE, new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, false));
        this.defaultEditors.put(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, true));
        this.defaultEditors.put(Short.TYPE, new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, false));
        this.defaultEditors.put(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, true));
        this.defaultEditors.put(Integer.TYPE, new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, false));
        this.defaultEditors.put(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, true));
        this.defaultEditors.put(Long.TYPE, new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, false));
        this.defaultEditors.put(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, true));
        this.defaultEditors.put(Float.TYPE, new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, false));
        this.defaultEditors.put(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, true));
        this.defaultEditors.put(Double.TYPE, new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, false));
        this.defaultEditors.put(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, true));
        this.defaultEditors.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyEditorRegistrySupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new CustomNumberEditor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyEditorRegistrySupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, true));
        this.defaultEditors.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyEditorRegistrySupport.class$("java.math.BigInteger")) : class$java$math$BigInteger, new CustomNumberEditor(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyEditorRegistrySupport.class$("java.math.BigInteger")) : class$java$math$BigInteger, true));
        if (this.configValueEditorsActive) {
            this.defaultEditors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = PropertyEditorRegistrySupport.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, new StringArrayPropertyEditor());
        }
    }

    protected void copyDefaultEditorsTo(PropertyEditorRegistrySupport target) {
        target.defaultEditors = this.defaultEditors;
        target.defaultEditorsActive = this.defaultEditorsActive;
        target.configValueEditorsActive = this.configValueEditorsActive;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (requiredType == null && propertyPath == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (this.customEditors == null) {
            this.customEditors = CollectionFactory.createLinkedMapIfPossible(16);
        }
        if (propertyPath != null) {
            this.customEditors.put(propertyPath, new CustomEditorHolder(propertyEditor, requiredType));
            this.propertySpecificEditorsRegistered = true;
        } else {
            this.customEditors.put(requiredType, propertyEditor);
            this.customEditorCache = null;
        }
    }

    public void registerSharedEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
        if (this.sharedEditors == null) {
            this.sharedEditors = new HashSet();
        }
        this.sharedEditors.add(propertyEditor);
    }

    public boolean isSharedEditor(PropertyEditor propertyEditor) {
        return this.sharedEditors != null && this.sharedEditors.contains(propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        if (this.customEditors == null) {
            return null;
        }
        Class requiredTypeToUse = requiredType;
        if (propertyPath != null) {
            if (this.propertySpecificEditorsRegistered) {
                PropertyEditor editor = this.getCustomEditor(propertyPath, requiredType);
                if (editor == null) {
                    LinkedList strippedPaths = new LinkedList();
                    this.addStrippedPropertyPaths(strippedPaths, "", propertyPath);
                    Iterator it = strippedPaths.iterator();
                    while (it.hasNext() && editor == null) {
                        String strippedPath = (String)it.next();
                        editor = this.getCustomEditor(strippedPath, requiredType);
                    }
                }
                if (editor != null) {
                    return editor;
                }
            }
            if (requiredType == null) {
                requiredTypeToUse = this.getPropertyType(propertyPath);
            }
        }
        return this.getCustomEditor(requiredTypeToUse);
    }

    public boolean hasCustomEditorForElement(Class elementType, String propertyPath) {
        if (this.customEditors == null) {
            return false;
        }
        if (propertyPath != null && this.propertySpecificEditorsRegistered) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                CustomEditorHolder editorHolder;
                String regPath;
                Map.Entry entry = it.next();
                if (!(entry.getKey() instanceof String) || !PropertyAccessorUtils.matchesProperty(regPath = (String)entry.getKey(), propertyPath) || (editorHolder = (CustomEditorHolder)entry.getValue()).getPropertyEditor(elementType) == null) continue;
                return true;
            }
        }
        return elementType != null && this.customEditors.containsKey(elementType);
    }

    protected Class getPropertyType(String propertyPath) {
        return null;
    }

    private PropertyEditor getCustomEditor(String propertyName, Class requiredType) {
        CustomEditorHolder holder = (CustomEditorHolder)this.customEditors.get(propertyName);
        return holder != null ? holder.getPropertyEditor(requiredType) : null;
    }

    private PropertyEditor getCustomEditor(Class requiredType) {
        if (requiredType == null) {
            return null;
        }
        PropertyEditor editor = (PropertyEditor)this.customEditors.get(requiredType);
        if (editor == null) {
            if (this.customEditorCache != null) {
                editor = (PropertyEditor)this.customEditorCache.get(requiredType);
            }
            if (editor == null) {
                Iterator it = this.customEditors.keySet().iterator();
                while (it.hasNext() && editor == null) {
                    Object key = it.next();
                    if (!(key instanceof Class) || !((Class)key).isAssignableFrom(requiredType)) continue;
                    editor = (PropertyEditor)this.customEditors.get(key);
                    if (this.customEditorCache == null) {
                        this.customEditorCache = new HashMap();
                    }
                    this.customEditorCache.put(requiredType, editor);
                }
            }
        }
        return editor;
    }

    protected Class guessPropertyTypeFromEditors(String propertyName) {
        if (this.customEditors != null) {
            CustomEditorHolder editorHolder = (CustomEditorHolder)this.customEditors.get(propertyName);
            if (editorHolder == null) {
                LinkedList strippedPaths = new LinkedList();
                this.addStrippedPropertyPaths(strippedPaths, "", propertyName);
                Iterator it = strippedPaths.iterator();
                while (it.hasNext() && editorHolder == null) {
                    String strippedName = (String)it.next();
                    editorHolder = (CustomEditorHolder)this.customEditors.get(strippedName);
                }
            }
            if (editorHolder != null) {
                return editorHolder.getRegisteredType();
            }
        }
        return null;
    }

    protected void copyCustomEditorsTo(PropertyEditorRegistry target, String nestedProperty) {
        String actualPropertyName;
        String string = actualPropertyName = nestedProperty != null ? PropertyAccessorUtils.getPropertyName(nestedProperty) : null;
        if (this.customEditors != null) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getKey() instanceof Class) {
                    Class requiredType = (Class)entry.getKey();
                    PropertyEditor editor = (PropertyEditor)entry.getValue();
                    target.registerCustomEditor(requiredType, editor);
                    continue;
                }
                if (!(entry.getKey() instanceof String)) continue;
                String editorPath = (String)entry.getKey();
                CustomEditorHolder editorHolder = (CustomEditorHolder)entry.getValue();
                if (nestedProperty != null) {
                    int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(editorPath);
                    if (pos == -1) continue;
                    String editorNestedProperty = editorPath.substring(0, pos);
                    String editorNestedPath = editorPath.substring(pos + 1);
                    if (!editorNestedProperty.equals(nestedProperty) && !editorNestedProperty.equals(actualPropertyName)) continue;
                    target.registerCustomEditor(editorHolder.getRegisteredType(), editorNestedPath, editorHolder.getPropertyEditor());
                    continue;
                }
                target.registerCustomEditor(editorHolder.getRegisteredType(), editorPath, editorHolder.getPropertyEditor());
            }
        }
    }

    private void addStrippedPropertyPaths(List strippedPaths, String nestedPath, String propertyPath) {
        int endIndex;
        int startIndex = propertyPath.indexOf(91);
        if (startIndex != -1 && (endIndex = propertyPath.indexOf(93)) != -1) {
            String prefix = propertyPath.substring(0, startIndex);
            String key = propertyPath.substring(startIndex, endIndex + 1);
            String suffix = propertyPath.substring(endIndex + 1, propertyPath.length());
            strippedPaths.add(nestedPath + prefix + suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix, suffix);
            this.addStrippedPropertyPaths(strippedPaths, nestedPath + prefix + key, suffix);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class registeredType) {
            this.propertyEditor = propertyEditor;
            this.registeredType = registeredType;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class requiredType) {
            if (this.registeredType == null || requiredType != null && (ClassUtils.isAssignable(this.registeredType, requiredType) || ClassUtils.isAssignable(requiredType, this.registeredType)) || requiredType == null && !(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }
}

