/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.interceptor;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.http.IriDecoderHelper;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIParameterInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(URIParameterInInterceptor.class);

    public URIParameterInInterceptor() {
        super("unmarshal");
        this.addBefore(XMLMessageInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) {
        String path = (String)message.get("relative.path");
        String method = (String)message.get(Message.HTTP_REQUEST_METHOD);
        String contentType = (String)message.get("Content-Type");
        LOG.info("URIParameterInterceptor handle message on path [" + path + "] with content-type [" + contentType + "]");
        BindingOperationInfo op = message.getExchange().get(BindingOperationInfo.class);
        URIMapper mapper = (URIMapper)message.getExchange().get(Service.class).get(URIMapper.class.getName());
        String location = mapper.getLocation(op);
        List<MessagePartInfo> parts = op.getOperationInfo().getInput().getMessageParts();
        if (parts.size() == 0) {
            message.setContent(Object.class, Collections.EMPTY_LIST);
            return;
        }
        if (parts.size() > 1) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("SINGLE_PART_REQUIRED", LOG, new Object[0]));
        }
        message.getInterceptorChain().add(new XMLMessageInInterceptor());
        message.getInterceptorChain().add(new DocLiteralInInterceptor());
        MessagePartInfo part = parts.get(0);
        List<IriDecoderHelper.Param> params = null;
        if ("application/x-www-form-urlencoded.".equals(contentType)) {
            params = IriDecoderHelper.decode(path, location, message.getContent(InputStream.class));
        } else if ("application/xml".equals(contentType)) {
            params = IriDecoderHelper.decodeIri(path, location);
        } else if ("text/xml".equals(contentType)) {
            params = IriDecoderHelper.decodeIri(path, location);
        } else if (!"multipart/form-data".equals(contentType)) {
            params = IriDecoderHelper.decodeIri(path, location);
        }
        this.mergeParams(message, path, method, part, params);
    }

    private void mergeParams(Message message, String path, String method, MessagePartInfo part, List<IriDecoderHelper.Param> params) {
        Document doc;
        List<SchemaInfo> schemas = part.getMessageInfo().getOperation().getInterface().getService().getSchemas();
        if ("POST".equals(method) || "PUT".equals(method)) {
            XMLInputFactory inputFactory = StaxInInterceptor.getXMLInputFactory(message);
            try {
                XMLStreamReader reader = inputFactory.createXMLStreamReader(message.getContent(InputStream.class));
                doc = StaxUtils.read(reader);
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
            doc = IriDecoderHelper.interopolateParams(doc, part.getXmlSchema(), schemas, params);
        } else {
            doc = IriDecoderHelper.buildDocument(part.getXmlSchema(), schemas, params);
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader(new DOMSource(doc));
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
        message.setContent(XMLStreamReader.class, reader);
    }
}

