/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.bindings.xformat.XMLBindingMessageFormat;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.validator.ServiceValidator;

public class XMLFormatValidator
extends ServiceValidator {
    public XMLFormatValidator() {
    }

    public XMLFormatValidator(ServiceInfo s) {
        this.service = s;
    }

    public boolean isValid() {
        return this.checkXMLBindingFormat();
    }

    private boolean checkXMLBindingFormat() {
        Collection<BindingInfo> bindings = this.service.getBindings();
        if (bindings != null) {
            for (BindingInfo binding : bindings) {
                if (!"http://cxf.apache.org/bindings/xformat".equalsIgnoreCase(binding.getBindingId()) || this.checkXMLFormat(binding)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkXMLFormat(BindingInfo binding) {
        Collection<BindingOperationInfo> bos = binding.getOperations();
        boolean result = true;
        boolean needRootNode = false;
        for (BindingOperationInfo bo : bos) {
            OperationInfo op = binding.getInterface().getOperation(bo.getName());
            needRootNode = false;
            if (op.getInput().getMessageParts().size() == 0 || op.getInput().getMessageParts().size() > 1) {
                needRootNode = true;
            }
            if (!needRootNode) continue;
            String path = "Binding(" + binding.getName().getLocalPart() + "):BindingOperation(" + bo.getName() + ")";
            List<ExtensibilityElement> inExtensors = bo.getInput().getExtensors(ExtensibilityElement.class);
            Iterator<ExtensibilityElement> itIn = null;
            if (inExtensors != null) {
                itIn = inExtensors.iterator();
            }
            if (this.findXMLFormatRootNode(itIn, bo, path + "-input")) {
                needRootNode = false;
                if (op.getOutput().getMessageParts().size() == 0 || op.getOutput().getMessageParts().size() > 1) {
                    needRootNode = true;
                }
                if (!needRootNode) continue;
                List<ExtensibilityElement> outExtensors = bo.getOutput().getExtensors(ExtensibilityElement.class);
                Iterator<ExtensibilityElement> itOut = null;
                if (outExtensors != null) {
                    itOut = outExtensors.iterator();
                }
                if (result = result && this.findXMLFormatRootNode(itOut, bo, path + "-Output")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean findXMLFormatRootNode(Iterator it, BindingOperationInfo bo, String errorPath) {
        while (it != null && it.hasNext()) {
            Object ext = it.next();
            if (!(ext instanceof XMLBindingMessageFormat)) continue;
            XMLBindingMessageFormat xmlFormat = (XMLBindingMessageFormat)ext;
            QName rootNodeName = bo.getName();
            if (xmlFormat.getRootNode() != null) {
                if (xmlFormat.getRootNode().equals(rootNodeName)) {
                    return true;
                }
                this.addErrorMessage(errorPath + ": wrong value of rootNode attribute, the value should be " + rootNodeName);
                return false;
            }
            this.addErrorMessage(errorPath + ": empty value of rootNode attribute, the value should be " + rootNodeName);
            return false;
        }
        this.addErrorMessage(errorPath + ": missing xml format body element");
        return false;
    }
}

