/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.TokenConsumer;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Option
implements TokenConsumer {
    private static final Logger LOG = LogUtils.getL7dLogger(Option.class);
    private static final String VALUE_ENUM_SEPARATOR = "|";
    protected Element argument;
    protected Element annotation;
    private final Element element;
    private Element valueType;
    private int numMatches;

    public Option(Element el) {
        this.element = el;
        NodeList list = this.element.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "associatedArgument");
        if (list != null && list.getLength() > 0) {
            this.argument = (Element)list.item(0);
        }
        if ((list = this.element.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "annotation")) != null && list.getLength() > 0) {
            this.annotation = (Element)list.item(0);
        }
        if (this.annotation == null && this.argument != null && (list = this.argument.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "annotation")) != null && list.getLength() > 0) {
            this.annotation = (Element)list.item(0);
        }
    }

    public boolean hasArgument() {
        return this.argument != null;
    }

    public boolean hasImmediateArgument() {
        return this.hasArgument() && "immediate".equals(this.argument.getAttribute("placement"));
    }

    public boolean accept(TokenInputStream args, Element result, ErrorVisitor errors) {
        if (args.available() == 0) {
            return false;
        }
        String arg = args.peek();
        if (arg == null) {
            LOG.severe("ARGUMENT_IS_NULL_MSG");
        }
        NodeList switches = this.element.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "switch");
        boolean accepted = false;
        for (int i = 0; i < switches.getLength(); ++i) {
            String switchArg = "-" + switches.item(i).getFirstChild().getNodeValue();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("switchArg is " + switchArg);
            }
            if (!(this.hasImmediateArgument() ? arg.startsWith(switchArg) : arg.equals(switchArg))) continue;
            LOG.fine("Matches a switch!!!");
            args.read();
            Element optionEl = result.getOwnerDocument().createElementNS("http://cxf.apache.org/Xutil/Command", "option");
            optionEl.setAttribute("name", this.getName());
            if (this.hasArgument()) {
                String argValue = this.hasImmediateArgument() ? arg.substring(switchArg.length()) : this.readArgumentValue(args, switchArg, errors);
                if (argValue == null) break;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Setting argument value of option to " + argValue);
                }
                optionEl.appendChild(result.getOwnerDocument().createTextNode(argValue));
            }
            result.appendChild(optionEl);
            ++this.numMatches;
            accepted = true;
        }
        return accepted;
    }

    private String readArgumentValue(TokenInputStream args, String switchArg, ErrorVisitor errors) {
        String value = null;
        if (args.available() > 0) {
            value = args.read();
            if (value.startsWith("-")) {
                errors.add(new ErrorVisitor.InvalidOption(switchArg));
                value = null;
            } else if (this.hasInvalidCharacter(value)) {
                errors.add(new ErrorVisitor.UserError(switchArg + " has invalid character!"));
            }
            if (!this.isInEnumArgumentValue(value)) {
                errors.add(new ErrorVisitor.UserError(switchArg + " " + value + " not in the enumeration value list!"));
            }
        } else {
            errors.add(new ErrorVisitor.InvalidOption(switchArg));
        }
        return value;
    }

    private boolean hasInvalidCharacter(String argValue) {
        NodeList list = this.argument.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "valuetype");
        String valuetypeStr = null;
        if (list != null && list.getLength() > 0) {
            this.valueType = (Element)list.item(0);
            valuetypeStr = this.valueType.getFirstChild().getNodeValue();
            if ("IdentifyString".equals(valuetypeStr)) {
                return !this.isIdentifyString(argValue);
            }
            if ("NamingSpacePackageString".equals(valuetypeStr)) {
                return !this.isNamingSpacePackageString(argValue);
            }
            if ("Digital".equals(valuetypeStr)) {
                for (int i = 0; i < argValue.length(); ++i) {
                    if (Character.isDigit(argValue.charAt(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInEnumArgumentValue(String argValue) {
        boolean result = true;
        NodeList list = this.argument.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "valueenum");
        if (list != null && list.getLength() == 1) {
            result = false;
            String enumValue = list.item(0).getTextContent();
            StringTokenizer stk = new StringTokenizer(enumValue, VALUE_ENUM_SEPARATOR);
            if (stk.countTokens() <= 0) {
                return result;
            }
            while (stk.hasMoreTokens()) {
                if (!argValue.equals(stk.nextToken())) continue;
                result = true;
            }
        }
        return result;
    }

    private boolean isIdentifyString(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '.' || Character.isJavaIdentifierPart(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isNamingSpacePackageString(String value) {
        if (value.indexOf("=") < 0) {
            return this.isIdentifyString(value);
        }
        String packageName = value.substring(value.indexOf("=") + 1, value.length());
        return this.isIdentifyString(packageName);
    }

    public boolean isSatisfied(ErrorVisitor errors) {
        if (errors.getErrors().size() > 0) {
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("For this option, minOccurs=" + this.element.getAttribute("minOccurs") + " and maxOccurs=" + this.element.getAttribute("maxOccurs") + ", numMatches currently " + this.numMatches);
        }
        boolean result = true;
        if (!this.isAtleastMinimum()) {
            errors.add(new ErrorVisitor.MissingOption(this));
            result = false;
        }
        if (result && !this.isNoGreaterThanMaximum()) {
            errors.add(new ErrorVisitor.DuplicateOption(this.getName()));
            result = false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("isSatisfied() returning " + result);
        }
        return result;
    }

    private boolean isAtleastMinimum() {
        boolean result = true;
        int minOccurs = 0;
        result = !"".equals(this.element.getAttribute("minOccurs")) ? this.numMatches >= Integer.parseInt(this.element.getAttribute("minOccurs")) : this.numMatches >= minOccurs;
        return result;
    }

    private boolean isNoGreaterThanMaximum() {
        boolean result = true;
        int maxOccurs = 1;
        result = !"".equals(this.element.getAttribute("maxOccurs")) ? "unbounded".equals(this.element.getAttribute("maxOccurs")) || this.numMatches <= Integer.parseInt(this.element.getAttribute("maxOccurs")) : this.numMatches <= maxOccurs;
        return result;
    }

    public String getName() {
        return this.element.getAttribute("id");
    }

    public String getAnnotation() {
        return this.annotation.getFirstChild().getNodeValue();
    }

    public String getPrimarySwitch() {
        NodeList switches = this.element.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "switch");
        return switches.item(0).getFirstChild().getNodeValue();
    }

    public String toString() {
        return this.getName();
    }
}

