/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.DateTypeCustomGenerator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.apache.cxf.wsdl11.WSDLDefinitionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11Generator
extends AbstractGenerator<Definition> {
    @Override
    public Definition generate(File dir) {
        File file = this.getOutputBase();
        if (file == null && dir != null) {
            file = dir.isDirectory() ? new File(dir, this.getServiceModel().getName().getLocalPart() + ".wsdl") : dir;
        } else if (dir == null) {
            file = new File(this.getServiceModel().getName().getLocalPart() + ".wsdl");
        }
        File outputdir = this.createOutputDir(file);
        Definition def = null;
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
            ServiceWSDLBuilder builder = new ServiceWSDLBuilder(this.getBus(), this.getServiceModel());
            builder.setUseSchemaImports(this.allowImports());
            String name = file.getName();
            if (name.endsWith(".wsdl")) {
                name = name.substring(0, name.lastIndexOf(".wsdl"));
            }
            builder.setBaseFileName(name);
            HashMap<String, SchemaInfo> imports = new HashMap<String, SchemaInfo>();
            def = builder.build(imports);
            wsdlWriter.writeWSDL(def, (OutputStream)os);
            ((OutputStream)os).close();
            if (def.getImports().size() > 0) {
                for (Import import_ : WSDLDefinitionBuilder.getImports(def)) {
                    Definition wsdlDef = import_.getDefinition();
                    File wsdlFile = null;
                    wsdlFile = !StringUtils.isEmpty(import_.getLocationURI()) ? new File(outputdir, import_.getLocationURI()) : new File(outputdir, wsdlDef.getQName().getLocalPart() + ".wsdl");
                    BufferedOutputStream wsdlOs = new BufferedOutputStream(new FileOutputStream(wsdlFile));
                    wsdlWriter.writeWSDL(wsdlDef, (OutputStream)wsdlOs);
                    ((OutputStream)wsdlOs).close();
                }
            }
            for (Map.Entry entry : imports.entrySet()) {
                File impfile = new File(file.getParentFile(), (String)entry.getKey());
                os = new BufferedOutputStream(new FileOutputStream(impfile));
                ((SchemaInfo)entry.getValue()).getSchema().write((OutputStream)os);
                ((OutputStream)os).close();
            }
            this.customizing(outputdir, name, imports.keySet());
        }
        catch (WSDLException wex) {
            wex.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            throw new ToolException("Output file " + file + " not found", (Throwable)fnfe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return def;
    }

    private void customizing(File outputdir, String wsdlName, Set<String> imports) {
        DateTypeCustomGenerator generator = new DateTypeCustomGenerator();
        generator.setWSDLName(wsdlName);
        generator.setServiceModel(this.getServiceModel());
        generator.setAllowImports(this.allowImports());
        generator.addSchemaFiles(imports);
        generator.generate(outputdir);
    }
}

