/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Soap11FaultOutInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(Soap11FaultOutInterceptor.class);

    public Soap11FaultOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        message.put(Message.RESPONSE_CODE, new Integer(500));
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        Fault f = (Fault)((Object)message.getContent(Exception.class));
        SoapFault fault = SoapFault.createFault(f, message.getVersion());
        try {
            Map<String, String> namespaces = fault.getNamespaces();
            for (Map.Entry<String, String> e : namespaces.entrySet()) {
                writer.writeNamespace(e.getKey(), e.getValue());
            }
            String ns = message.getVersion().getNamespace();
            String defaultPrefix = writer.getPrefix(ns);
            if (defaultPrefix == null) {
                defaultPrefix = StaxUtils.getUniquePrefix((XMLStreamWriter)writer, (String)ns, (boolean)false);
                writer.writeStartElement(defaultPrefix, "Fault", ns);
                writer.writeNamespace(defaultPrefix, ns);
            } else {
                writer.writeStartElement(defaultPrefix, "Fault", ns);
            }
            writer.writeStartElement("faultcode");
            String codeString = fault.getCodeString(this.getFaultCodePrefix(writer, fault.getFaultCode()), defaultPrefix);
            writer.writeCharacters(codeString);
            writer.writeEndElement();
            writer.writeStartElement("faultstring");
            if (fault.getMessage() != null) {
                writer.writeCharacters(fault.getMessage());
            } else {
                writer.writeCharacters("Fault occurred while processing.");
            }
            writer.writeEndElement();
            String config = (String)message.getContextualProperty("faultStackTraceEnabled");
            if (config != null && Boolean.valueOf(config).booleanValue() && fault.getCause() != null) {
                StringBuffer sb = new StringBuffer();
                for (StackTraceElement ste : fault.getCause().getStackTrace()) {
                    sb.append(ste.getClassName() + "!" + ste.getMethodName() + "!" + ste.getFileName() + "!" + ste.getLineNumber() + "\n");
                }
                try {
                    Element detail = fault.getDetail();
                    if (detail == null) {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setNamespaceAware(true);
                        Document doc = factory.newDocumentBuilder().newDocument();
                        Element stackTrace = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "stackTrace");
                        stackTrace.setTextContent(sb.toString());
                        detail = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "detail");
                        fault.setDetail(detail);
                        detail.appendChild(stackTrace);
                    } else {
                        Element stackTrace = detail.getOwnerDocument().createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "stackTrace");
                        detail.appendChild(stackTrace);
                    }
                }
                catch (ParserConfigurationException pe) {
                    // empty catch block
                }
            }
            if (fault.hasDetails()) {
                Element detail = fault.getDetail();
                writer.writeStartElement("detail");
                NodeList details = detail.getChildNodes();
                for (int i = 0; i < details.getLength(); ++i) {
                    StaxUtils.writeNode((Node)details.item(i), (XMLStreamWriter)writer, (boolean)true);
                }
                writer.writeEndElement();
            }
            if (fault.getRole() != null) {
                writer.writeStartElement("faultactor");
                writer.writeCharacters(fault.getRole());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }
}

