/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;

public class SoapActionOutInterceptor
extends AbstractSoapInterceptor {
    public SoapActionOutInterceptor() {
        super("post-logical");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        if (message != message.getExchange().getInMessage()) {
            this.setSoapAction(message);
        }
    }

    private void setSoapAction(SoapMessage message) {
        String ct;
        BindingOperationInfo boi = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        String action = this.getSoapAction(message, boi);
        if (message.getVersion() instanceof Soap11) {
            HashMap<String, List<String>> reqHeaders = CastUtils.cast((Map)((Map)message.get(Message.PROTOCOL_HEADERS)));
            if (reqHeaders == null) {
                reqHeaders = new HashMap<String, List<String>>();
            }
            if (reqHeaders.size() == 0) {
                message.put(Message.PROTOCOL_HEADERS, reqHeaders);
            }
            if (!reqHeaders.containsKey("SOAPAction")) {
                reqHeaders.put("SOAPAction", Collections.singletonList(action));
            }
        } else if (message.getVersion() instanceof Soap12 && !"\"\"".equals(action) && (ct = (String)message.get("Content-Type")).indexOf("action=\"") == -1) {
            ct = ct + "; action=" + action;
            message.put("Content-Type", ct);
        }
    }

    private String getSoapAction(SoapMessage message, BindingOperationInfo boi) {
        String action = (String)message.get("SOAPAction");
        if (action == null) {
            if (boi == null) {
                action = "\"\"";
            } else {
                SoapOperationInfo soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
                String string = soi == null ? "\"\"" : (action = soi.getAction() == null ? "\"\"" : soi.getAction());
            }
        }
        if (!action.startsWith("\"")) {
            action = new StringBuffer().append("\"").append(action).append("\"").toString();
        }
        return action;
    }
}

