/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import org.apache.cxf.helpers.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBUtils {
    public static final String JAXB_URI = "http://java.sun.com/xml/ns/jaxb";
    private static final char[] XML_NAME_PUNCTUATION_CHARS = new char[]{'-', '.', ':', '\u00b7', '\u0387', '\u06dd', '\u06de', '_'};
    private static final String XML_NAME_PUNCTUATION_STRING = new String(XML_NAME_PUNCTUATION_CHARS);
    private static final Map<String, String> BUILTIN_DATATYPES_MAP = new HashMap<String, String>();
    private static final Map<String, Class<?>> HOLDER_TYPES_MAP;

    private JAXBUtils() {
    }

    public static String builtInTypeToJavaType(String type) {
        return BUILTIN_DATATYPES_MAP.get(type);
    }

    public static Class<?> holderClass(String type) {
        return HOLDER_TYPES_MAP.get(type);
    }

    public static boolean isJavaKeyword(String word) {
        return JavaUtils.isJavaKeyword(word);
    }

    public static String namespaceURIToPackage(String namespaceURI) {
        try {
            return JAXBUtils.nameSpaceURIToPackage(new URI(namespaceURI));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static String nameSpaceURIToPackage(URI uri) {
        int index;
        String path;
        StringBuffer packageName = new StringBuffer();
        String authority = uri.getAuthority();
        if (authority == null && "urn".equals(uri.getScheme())) {
            authority = uri.getSchemeSpecificPart();
        }
        if (null != authority && !"".equals(authority)) {
            String token;
            StringTokenizer st;
            if ("urn".equals(uri.getScheme())) {
                packageName.append(authority);
                for (int i = 0; i < packageName.length(); ++i) {
                    if (packageName.charAt(i) != '-') continue;
                    packageName.setCharAt(i, '.');
                }
                authority = packageName.toString();
                packageName.setLength(0);
                st = new StringTokenizer(authority, ":");
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (packageName.length() > 0) {
                        packageName.insert(0, ".");
                        packageName.insert(0, JAXBUtils.normalizePackageNamePart(token));
                        continue;
                    }
                    packageName.insert(0, token);
                }
                authority = packageName.toString();
                packageName.setLength(0);
            }
            if ((st = new StringTokenizer(authority, ".")).hasMoreTokens()) {
                token = null;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (packageName.length() == 0) {
                        if ("www".equals(token)) {
                            continue;
                        }
                    } else {
                        packageName.insert(0, ".");
                    }
                    packageName.insert(0, JAXBUtils.normalizePackageNamePart(token));
                }
            }
        }
        if ((path = uri.getPath()) == null) {
            path = "";
        }
        if ((index = path.lastIndexOf(46)) < 0) {
            index = path.length();
        }
        StringTokenizer st = new StringTokenizer(path.substring(0, index), "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (packageName.length() > 0) {
                packageName.append('.');
            }
            packageName.append(JAXBUtils.normalizePackageNamePart(token));
        }
        return packageName.toString();
    }

    public static boolean isAsync(Method method) {
        return method.getName().endsWith("Async") && (method.getReturnType().equals(Response.class) || method.getReturnType().equals(Future.class));
    }

    public static boolean isAsyncPolling(Method method) {
        return method.getName().endsWith("Async") && method.getReturnType().equals(Response.class);
    }

    public static boolean isAsyncCallback(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        return method.getName().endsWith("Async") && method.getReturnType().equals(Future.class) && AsyncHandler.class.isAssignableFrom(paramTypes[paramTypes.length - 1]);
    }

    private static String normalizePackageNamePart(String name) {
        int i;
        StringBuffer sname = new StringBuffer(name.toLowerCase());
        for (i = 0; i < sname.length(); ++i) {
            sname.setCharAt(i, Character.toLowerCase(sname.charAt(i)));
        }
        for (i = 0; i < sname.length(); ++i) {
            if (Character.isJavaIdentifierPart(sname.charAt(i))) continue;
            sname.setCharAt(i, '_');
        }
        if (JAXBUtils.isJavaKeyword(sname.toString())) {
            sname.insert(0, '_');
        }
        if (!Character.isJavaIdentifierStart(sname.charAt(0))) {
            sname.insert(0, '_');
        }
        return sname.toString();
    }

    public static String nameToIdentifier(String name, IdentifierType type) {
        if (null == name || name.length() == 0) {
            return name;
        }
        boolean legalIdentifier = false;
        StringBuffer buf = new StringBuffer(name);
        legalIdentifier = Character.isJavaIdentifierStart(buf.charAt(0));
        for (int i = 1; i < name.length() && legalIdentifier; ++i) {
            legalIdentifier = legalIdentifier && Character.isJavaIdentifierPart(buf.charAt(i));
        }
        boolean conventionalIdentifier = JAXBUtils.isConventionalIdentifier(buf, type);
        if (legalIdentifier && conventionalIdentifier) {
            if (JAXBUtils.isJavaKeyword(name) && type == IdentifierType.VARIABLE) {
                name = JAXBUtils.normalizePackageNamePart(name.toString());
            }
            return name;
        }
        ArrayList<String> words = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(name, XML_NAME_PUNCTUATION_STRING);
        while (st.hasMoreTokens()) {
            words.add(st.nextToken());
        }
        for (int i = 0; i < words.size(); ++i) {
            JAXBUtils.splitWord(words, i);
        }
        return JAXBUtils.makeConventionalIdentifier(words, type);
    }

    private static void splitWord(List<String> words, int listIndex) {
        String word = words.get(listIndex);
        if (word.length() <= 1) {
            return;
        }
        int index = listIndex + 1;
        StringBuffer sword = new StringBuffer(word);
        int first = 0;
        char firstChar = sword.charAt(first);
        if (Character.isLowerCase(firstChar)) {
            sword.setCharAt(first, Character.toUpperCase(firstChar));
        }
        int i = 1;
        while (i < sword.length()) {
            if (Character.isDigit(firstChar)) {
                while (i < sword.length() && Character.isDigit(sword.charAt(i))) {
                    ++i;
                }
            } else if (JAXBUtils.isCasedLetter(firstChar)) {
                boolean previousIsLower = Character.isLowerCase(firstChar);
                while (!(i >= sword.length() || !JAXBUtils.isCasedLetter(sword.charAt(i)) || Character.isUpperCase(sword.charAt(i)) && previousIsLower)) {
                    previousIsLower = Character.isLowerCase(sword.charAt(i));
                    ++i;
                }
            } else {
                while (i < sword.length() && (JAXBUtils.isMark(sword.charAt(i)) || !JAXBUtils.isCasedLetter(sword.charAt(i)))) {
                    ++i;
                }
            }
            String newWord = sword.substring(first, i);
            words.add(index, newWord);
            ++index;
            if (i >= sword.length()) break;
            first = i;
            firstChar = sword.charAt(first);
        }
        if (index > listIndex + 1) {
            words.remove(listIndex);
        }
    }

    private static boolean isMark(char c) {
        return Character.isJavaIdentifierPart(c) && !Character.isLetter(c) && !Character.isDigit(c);
    }

    private static boolean isCasedLetter(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }

    private static boolean isConventionalIdentifier(StringBuffer buf, IdentifierType type) {
        if (null == buf || buf.length() == 0) {
            return false;
        }
        boolean result = false;
        if (IdentifierType.CONSTANT == type) {
            for (int i = 0; i < buf.length(); ++i) {
                if (!Character.isLowerCase(buf.charAt(i))) continue;
                return false;
            }
            result = true;
        } else if (IdentifierType.VARIABLE == type) {
            result = Character.isLowerCase(buf.charAt(0));
        } else {
            int pos = 3;
            if (!(IdentifierType.GETTER != type || buf.length() >= pos && "get".equals(buf.subSequence(0, 3)))) {
                return false;
            }
            if (!(IdentifierType.SETTER != type || buf.length() >= pos && "set".equals(buf.subSequence(0, 3)))) {
                return false;
            }
            pos = 0;
            result = Character.isUpperCase(buf.charAt(pos));
        }
        return result;
    }

    private static String makeConventionalIdentifier(List<String> words, IdentifierType type) {
        StringBuffer buf = new StringBuffer();
        boolean firstWord = true;
        if (IdentifierType.GETTER == type) {
            buf.append("get");
        } else if (IdentifierType.SETTER == type) {
            buf.append("set");
        }
        for (String w : words) {
            int l = buf.length();
            if (l > 0 && IdentifierType.CONSTANT == type) {
                buf.append('_');
                ++l;
            }
            buf.append(w);
            if (IdentifierType.CONSTANT == type) {
                for (int i = l; i < buf.length(); ++i) {
                    if (!Character.isLowerCase(buf.charAt(i))) continue;
                    buf.setCharAt(i, Character.toUpperCase(buf.charAt(i)));
                }
            } else if (IdentifierType.VARIABLE == type) {
                if (firstWord && Character.isUpperCase(buf.charAt(l))) {
                    buf.setCharAt(l, Character.toLowerCase(buf.charAt(l)));
                }
            } else if (firstWord && Character.isLowerCase(buf.charAt(l))) {
                buf.setCharAt(l, Character.toUpperCase(buf.charAt(l)));
            }
            firstWord = false;
        }
        return buf.toString();
    }

    public static Class<?> getValidClass(Class<?> cls) {
        if (cls.isEnum()) {
            return cls;
        }
        if (cls.isArray()) {
            return cls;
        }
        if (cls == Object.class || cls == String.class || cls == Holder.class) {
            cls = null;
        } else if (cls.isPrimitive() || cls.isInterface() || cls.isAnnotation()) {
            cls = null;
        }
        if (cls != null) {
            try {
                if (cls.getConstructor(new Class[0]) == null) {
                    cls = null;
                }
            }
            catch (NoSuchMethodException ex) {
                cls = null;
            }
        }
        return cls;
    }

    static {
        BUILTIN_DATATYPES_MAP.put("string", "java.lang.String");
        BUILTIN_DATATYPES_MAP.put("integer", "java.math.BigInteger");
        BUILTIN_DATATYPES_MAP.put("int", "int");
        BUILTIN_DATATYPES_MAP.put("long", "long");
        BUILTIN_DATATYPES_MAP.put("short", "short");
        BUILTIN_DATATYPES_MAP.put("decimal", "java.math.BigDecimal");
        BUILTIN_DATATYPES_MAP.put("float", "float");
        BUILTIN_DATATYPES_MAP.put("double", "double");
        BUILTIN_DATATYPES_MAP.put("boolean", "boolean");
        BUILTIN_DATATYPES_MAP.put("byte", "byte");
        BUILTIN_DATATYPES_MAP.put("QName", "javax.xml.namespace.QName");
        BUILTIN_DATATYPES_MAP.put("dateTime", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("base64Binary", "byte[]");
        BUILTIN_DATATYPES_MAP.put("hexBinary", "byte[]");
        BUILTIN_DATATYPES_MAP.put("unsignedInt", "long");
        BUILTIN_DATATYPES_MAP.put("unsignedShort", "short");
        BUILTIN_DATATYPES_MAP.put("unsignedByte", "byte");
        BUILTIN_DATATYPES_MAP.put("time", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("date", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gYear", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gYearMonth", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gMonth", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gMonthDay", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("gDay", "javax.xml.datatype.XMLGregorianCalendar");
        BUILTIN_DATATYPES_MAP.put("duration", "javax.xml.datatype.Duration");
        BUILTIN_DATATYPES_MAP.put("NOTATION", "javax.xml.namespace.QName");
        BUILTIN_DATATYPES_MAP.put("string", "java.lang.String");
        HOLDER_TYPES_MAP = new HashMap();
        HOLDER_TYPES_MAP.put("int", Integer.class);
        HOLDER_TYPES_MAP.put("long", Long.class);
        HOLDER_TYPES_MAP.put("short", Short.class);
        HOLDER_TYPES_MAP.put("float", Float.class);
        HOLDER_TYPES_MAP.put("double", Double.class);
        HOLDER_TYPES_MAP.put("boolean", Boolean.class);
        HOLDER_TYPES_MAP.put("byte", Byte.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentifierType {
        CLASS,
        INTERFACE,
        GETTER,
        SETTER,
        VARIABLE,
        CONSTANT;

    }
}

