/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container.admin;

import com.iona.cxf.container.Application;
import com.iona.cxf.container.ApplicationState;
import com.iona.cxf.container.ContainerBean;
import com.iona.cxf.container.ContainerException;
import com.iona.cxf.container.admin.ApplicationStateType;
import com.iona.cxf.container.admin.ApplicationType;
import com.iona.cxf.container.admin.ContainerFault;
import com.iona.cxf.container.admin.ContainerFaultType;
import com.iona.cxf.container.admin.ContainerService;
import com.iona.cxf.container.admin.ServiceType;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="ContainerService", serviceName="ContainerService", endpointInterface="com.iona.cxf.container.admin.ContainerService", targetNamespace="http://cxf.iona.com/container/admin")
public class ContainerAdminServiceImpl
implements ContainerService,
InitializingBean,
DisposableBean {
    private ContainerBean container;

    @Override
    public List<ApplicationType> listApplications() {
        List<Application> applications = this.container.getApplications();
        ArrayList<ApplicationType> list = new ArrayList<ApplicationType>();
        for (Application app : applications) {
            ApplicationType appType = new ApplicationType();
            appType.setName(app.getName());
            for (QName serviceQName : app.getServices()) {
                ServiceType serviceType = new ServiceType();
                serviceType.setName(serviceQName);
                appType.getServices().add(serviceType);
            }
            list.add(appType);
        }
        return list;
    }

    @Override
    public void stopApplication(String name) throws ContainerFault {
        try {
            this.container.stopApplication(name);
        }
        catch (ContainerException cex) {
            ContainerFaultType faultType = new ContainerFaultType();
            faultType.setError(cex.getMessage());
            throw new ContainerFault("Stopping application " + name + " failed.", faultType, cex);
        }
    }

    @Override
    public void startApplication(String name) throws ContainerFault {
        try {
            this.container.startApplication(name);
        }
        catch (ContainerException cex) {
            ContainerFaultType faultType = new ContainerFaultType();
            faultType.setError(cex.getMessage());
            throw new ContainerFault("Starting application " + name + " failed.", faultType, cex);
        }
    }

    @Override
    public void removeApplication(String name) throws ContainerFault {
        try {
            this.container.removeApplication(name);
        }
        catch (ContainerException cex) {
            ContainerFaultType faultType = new ContainerFaultType();
            faultType.setError(cex.getMessage());
            throw new ContainerFault("Removing application " + name + " failed.", faultType, cex);
        }
    }

    public void setContainer(ContainerBean c) {
        this.container = c;
    }

    @Override
    public void shutdown() throws ContainerFault {
        try {
            ApplicationContext context = this.container.getApplicationContext();
            Bus bus = (Bus)context.getBean("cxf");
            ShutdownThread t = new ShutdownThread(bus);
            t.start();
        }
        catch (Exception cex) {
            ContainerFaultType faultType = new ContainerFaultType();
            faultType.setError(cex.getMessage());
            throw new ContainerFault("Shutting down container failed.", faultType, cex);
        }
    }

    @Override
    public ApplicationStateType getApplicationState(String application) throws ContainerFault {
        try {
            ApplicationState state = this.container.getApplicationState(application);
            switch (state) {
                case STARTED: {
                    return ApplicationStateType.STARTED;
                }
                case STOPPED: {
                    return ApplicationStateType.STOPPED;
                }
            }
            return ApplicationStateType.FAILED;
        }
        catch (ContainerException cex) {
            ContainerFaultType faultType = new ContainerFaultType();
            faultType.setError(cex.getMessage());
            throw new ContainerFault("Could not get ApplicationState for application: " + application, faultType, cex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (null == this.container) {
            throw new Exception("Container not set for Bean.");
        }
    }

    public void destroy() throws Exception {
    }

    public class ShutdownThread
    extends Thread {
        private Bus bus;

        public ShutdownThread(Bus b) {
            this.bus = b;
        }

        public void run() {
            try {
                Thread.sleep(5000L);
                this.bus.shutdown(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

