/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoader {
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";
    public static final String LOCATOR_FACTORY_SELECTOR_PARAM = "locatorFactorySelector";
    public static final String LOCATOR_FACTORY_KEY_PARAM = "parentContextKey";
    private static final String DEFAULT_STRATEGIES_PATH = "ContextLoader.properties";
    private static final Properties defaultStrategies;
    private final Log logger = LogFactory.getLog((Class)(class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader));
    private WebApplicationContext context;
    private BeanFactoryReference parentContextRef;
    static /* synthetic */ Class class$org$springframework$web$context$ContextLoader;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$WebApplicationContext;

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws IllegalStateException, BeansException {
        if (servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null) {
            throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ContextLoader* definitions in your web.xml!");
        }
        servletContext.log("Initializing Spring root WebApplicationContext");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Root WebApplicationContext: initialization started");
        }
        long startTime = System.currentTimeMillis();
        try {
            ApplicationContext parent = this.loadParentContext(servletContext);
            this.context = this.createWebApplicationContext(servletContext, parent);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.context);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            if (this.logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                this.logger.info((Object)("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
            }
            return this.context;
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            this.logger.error((Object)"Context initialization failed", (Throwable)err);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)err);
            throw err;
        }
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        Class contextClass;
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoader.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(contextClass = this.determineContextClass(servletContext))) {
            throw new ApplicationContextException("Custom context class [" + contextClass.getName() + "] is not of type [" + (class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoader.class$("org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).getName() + "]");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass((Class)contextClass);
        wac.setParent(parent);
        wac.setServletContext(servletContext);
        String configLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (configLocation != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray((String)configLocation, (String)",; \t\n"));
        }
        wac.refresh();
        return wac;
    }

    protected Class determineContextClass(ServletContext servletContext) throws ApplicationContextException {
        String contextClassName = servletContext.getInitParameter(CONTEXT_CLASS_PARAM);
        if (contextClassName != null) {
            try {
                return ClassUtils.forName((String)contextClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)ex);
            }
        }
        contextClassName = defaultStrategies.getProperty((class$org$springframework$web$context$WebApplicationContext == null ? (class$org$springframework$web$context$WebApplicationContext = ContextLoader.class$("org.springframework.web.context.WebApplicationContext")) : class$org$springframework$web$context$WebApplicationContext).getName());
        try {
            return ClassUtils.forName((String)contextClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ApplicationContextException("Failed to load default context class [" + contextClassName + "]", (Throwable)ex);
        }
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ApplicationContext parentContext = null;
        String locatorFactorySelector = servletContext.getInitParameter(LOCATOR_FACTORY_SELECTOR_PARAM);
        String parentContextKey = servletContext.getInitParameter(LOCATOR_FACTORY_KEY_PARAM);
        if (parentContextKey != null) {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)locatorFactorySelector);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting parent context definition: using parent context key of '" + parentContextKey + "' with BeanFactoryLocator"));
            }
            this.parentContextRef = locator.useBeanFactory(parentContextKey);
            parentContext = (ApplicationContext)this.parentContextRef.getFactory();
        }
        return parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWebApplicationContext(ServletContext servletContext) {
        servletContext.log("Closing Spring root WebApplicationContext");
        try {
            if (this.context instanceof ConfigurableWebApplicationContext) {
                ((ConfigurableWebApplicationContext)this.context).close();
            }
        }
        finally {
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (this.parentContextRef != null) {
                this.parentContextRef.release();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'ContextLoader.properties': " + ex.getMessage());
        }
    }
}

