/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
public class WrapperBeanAnnotator implements Annotator {

    public void annotate(final JavaAnnotatable clz) {
        WrapperBeanClass beanClass = null;
        if (clz instanceof WrapperBeanClass) {
            beanClass = (WrapperBeanClass) clz;
        } else {
            throw new RuntimeException("WrapperBeanAnnotator expect JavaClass as input");
        }

        JAnnotation xmlRootElement = new JAnnotation(XmlRootElement.class);
        xmlRootElement.addElement(new JAnnotationElement("name", 
                                                         beanClass.getElementName().getLocalPart()));
        xmlRootElement.addElement(new JAnnotationElement("namespace", 
                                                         beanClass.getElementName().getNamespaceURI()));
        
        JAnnotation xmlAccessorType = new JAnnotation(XmlAccessorType.class);
        xmlAccessorType.addElement(new JAnnotationElement(null, XmlAccessType.FIELD));

        JAnnotation xmlType = new JAnnotation(XmlType.class);
        xmlType.addElement(new JAnnotationElement("name", 
                                                  beanClass.getElementName().getLocalPart()));
        xmlType.addElement(new JAnnotationElement("namespace", 
                                                  beanClass.getElementName().getNamespaceURI()));
        
        // Revisit: why annotation is string?
        beanClass.addAnnotation(xmlRootElement);
        beanClass.addAnnotation(xmlAccessorType);
        beanClass.addAnnotation(xmlType);
    }
}
