/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.validator.ServiceValidator;

public class UniqueBodyValidator
extends ServiceValidator {
    public static final Logger LOG = LogUtils.getL7dLogger(UniqueBodyValidator.class);

    public UniqueBodyValidator() {
    }

    public UniqueBodyValidator(ServiceInfo s) {
        this.service = s;
    }

    public boolean isValid() {
        return this.checkUniqueBody();
    }

    private boolean checkUniqueBody() {
        Collection endpoints = this.service.getEndpoints();
        if (endpoints != null) {
            for (EndpointInfo endpoint : endpoints) {
                if (this.isValidEndpoint(endpoint)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidEndpoint(EndpointInfo endpoint) {
        BindingInfo binding = endpoint.getBinding();
        HashMap<QName, QName> uniqueNames = new HashMap<QName, QName>();
        Collection bos = binding.getOperations();
        for (BindingOperationInfo bo : bos) {
            MessagePartInfo part;
            OperationInfo op = binding.getInterface().getOperation(bo.getName());
            if (op.getInput() == null || op.getInput().getMessageParts().size() != 1 || (part = (MessagePartInfo)op.getInput().getMessageParts().iterator().next()).getElementQName() == null) continue;
            QName mName = part.getElementQName();
            QName opName = (QName)uniqueNames.get(mName);
            if (opName != null) {
                Message msg = new Message("NON_UNIQUE_BODY", LOG, new Object[]{endpoint.getName(), op.getName(), opName, mName});
                this.addErrorMessage(msg.toString());
                return false;
            }
            uniqueNames.put(mName, op.getName());
        }
        return true;
    }
}

