/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.BareOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;

public class WrappedOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(WrappedOutInterceptor.class);
    private WrappedOutEndingInterceptor ending = new WrappedOutEndingInterceptor();

    public WrappedOutInterceptor() {
        this("marshal");
    }

    public WrappedOutInterceptor(String phase) {
        super(phase);
        this.addBefore(BareOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (bop != null && bop.isUnwrapped()) {
            XMLStreamWriter xmlWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            MessageInfo messageInfo = this.isRequestor(message) ? bop.getWrappedOperation().getOperationInfo().getInput() : bop.getWrappedOperation().getOperationInfo().getOutput();
            MessagePartInfo part = (MessagePartInfo)messageInfo.getMessageParts().get(0);
            QName name = part.getConcreteName();
            try {
                int x = 1;
                while (xmlWriter.getNamespaceContext().getNamespaceURI("ns" + x) != null) {
                    ++x;
                }
                xmlWriter.setPrefix("ns" + x, name.getNamespaceURI());
                xmlWriter.writeStartElement("ns" + x, name.getLocalPart(), name.getNamespaceURI());
                xmlWriter.writeNamespace("ns" + x, name.getNamespaceURI());
            }
            catch (XMLStreamException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
            message.getInterceptorChain().add((Interceptor)this.ending);
        }
    }

    public class WrappedOutEndingInterceptor
    extends AbstractOutDatabindingInterceptor {
        public WrappedOutEndingInterceptor() {
            super("marshal-ending");
        }

        public void handleMessage(Message message) throws Fault {
            try {
                XMLStreamWriter xtw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndElement();
                }
            }
            catch (XMLStreamException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
        }
    }
}

