/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;

public class ExchangeImpl
extends StringMapImpl
implements Exchange {
    private Destination destination;
    private boolean oneWay;
    private Message inMessage;
    private Message outMessage;
    private Message inFaultMessage;
    private Message outFaultMessage;
    private Session session;

    public Destination getDestination() {
        return this.destination;
    }

    public Message getInMessage() {
        return this.inMessage;
    }

    public Conduit getConduit(Message message) {
        return this.get(ConduitSelector.class) != null ? this.get(ConduitSelector.class).selectConduit(message) : null;
    }

    public Message getOutMessage() {
        return this.outMessage;
    }

    public Message getInFaultMessage() {
        return this.inFaultMessage;
    }

    public void setInFaultMessage(Message m) {
        this.inFaultMessage = m;
        m.setExchange(this);
    }

    public Message getOutFaultMessage() {
        return this.outFaultMessage;
    }

    public void setOutFaultMessage(Message m) {
        this.outFaultMessage = m;
        m.setExchange(this);
    }

    public void setDestination(Destination d) {
        this.destination = d;
    }

    public void setInMessage(Message m) {
        this.inMessage = m;
        if (null != m) {
            m.setExchange(this);
        }
    }

    public void setConduit(Conduit c) {
        this.put(ConduitSelector.class, new PreexistingConduitSelector(c, this.get(Endpoint.class)));
    }

    public void setOutMessage(Message m) {
        this.outMessage = m;
        if (null != m) {
            m.setExchange(this);
        }
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean b) {
        this.oneWay = b;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void clear() {
        super.clear();
        this.destination = null;
        this.oneWay = false;
        this.inMessage = null;
        this.outMessage = null;
        this.inFaultMessage = null;
        this.outFaultMessage = null;
        this.session = null;
    }
}

