/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;
import org.apache.cxf.wsdl.WSDLConstants;

public final class WSDLGeneratorFactory {
    private WSDLConstants.WSDLVersion wsdlVersion;

    public void setWSDLVersion(WSDLConstants.WSDLVersion v) {
        this.wsdlVersion = v;
    }

    protected String getGeneratorClassName() {
        String pkgName = this.getClass().getPackage().getName();
        return pkgName + "." + this.wsdlVersion.toString().toLowerCase() + "." + (Object)((Object)this.wsdlVersion) + "Generator";
    }

    public AbstractGenerator newGenerator() {
        AbstractGenerator generator = null;
        String clzName = this.getGeneratorClassName();
        try {
            generator = (AbstractGenerator)Class.forName(clzName).newInstance();
        }
        catch (Exception e) {
            throw new ToolException("Can not find the Generator for: " + clzName, (Throwable)e);
        }
        return generator;
    }
}

