/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.object;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.object.ObjectBindingConfiguration;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;

public class LocalServerListener
implements ServerLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(LocalServerListener.class);
    private DestinationFactory destinationFactory;
    private BindingFactory bindingFactory;
    private ObjectBindingConfiguration configuration = new ObjectBindingConfiguration();
    private Bus bus;

    public LocalServerListener(Bus bus, BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
        this.bus = bus;
    }

    public void startServer(Server server) {
        Endpoint endpoint = server.getEndpoint();
        Service service = endpoint.getService();
        BindingInfo bi = this.bindingFactory.createBindingInfo(service, "http://cxf.apache.org/binding/object", (Object)this.configuration);
        Binding binding = this.bindingFactory.createBinding(bi);
        String uri = "local://" + server.toString();
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(uri);
        try {
            Destination destination = this.getDestinationFactory().getDestination(ei);
            destination.setMessageObserver((MessageObserver)new OverrideBindingObserver(endpoint, binding, this.bus));
        }
        catch (IOException e1) {
            LOG.log(Level.WARNING, "Could not create local destination.", e1);
        }
    }

    public void stopServer(Server server) {
        String uri = "local://" + server.toString();
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(uri);
        try {
            Destination destination = this.getDestinationFactory().getDestination(ei);
            destination.shutdown();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Could not shutdown local destination.", e);
        }
    }

    public DestinationFactory getDestinationFactory() {
        if (this.destinationFactory == null) {
            this.retrieveDF();
        }
        return this.destinationFactory;
    }

    private synchronized void retrieveDF() {
        if (this.destinationFactory == null) {
            DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
            try {
                this.destinationFactory = dfm.getDestinationFactory("http://cxf.apache.org/transports/local");
            }
            catch (BusException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ObjectBindingConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ObjectBindingConfiguration configuration) {
        this.configuration = configuration;
    }

    public static class OverrideBindingObserver
    extends ChainInitiationObserver {
        private Binding binding;

        public OverrideBindingObserver(Endpoint endpoint, Binding binding, Bus bus) {
            super(endpoint, bus);
            this.binding = binding;
        }

        protected Binding getBinding() {
            return this.binding;
        }
    }
}

