/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaServerConduit;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.TypeMapCache;
import org.apache.cxf.binding.corba.runtime.CorbaDSIServant;
import org.apache.cxf.binding.corba.utils.CorbaBindingHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.Servant;

public class CorbaDestination
implements Destination {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaDestination.class);
    private AddressType address;
    private EndpointReferenceType reference;
    private ORB orb;
    private BindingInfo binding;
    private EndpointInfo endpointInfo;
    private OrbConfig orbConfig;
    private MessageObserver incomingObserver;
    private CorbaTypeMap typeMap;
    private byte[] objectId;
    private POA bindingPOA;
    private Object obj;

    public CorbaDestination(EndpointInfo ei, OrbConfig config) {
        this(ei, config, null);
    }

    public CorbaDestination(EndpointInfo ei, OrbConfig config, CorbaTypeMap tm) {
        this.address = (AddressType)((java.lang.Object)ei.getExtensor(AddressType.class));
        this.binding = ei.getBinding();
        this.reference = new EndpointReferenceType();
        AttributedURIType addr = new AttributedURIType();
        addr.setValue(this.address.getLocation());
        this.reference.setAddress(addr);
        this.endpointInfo = ei;
        this.orbConfig = config;
        this.typeMap = tm != null ? tm : TypeMapCache.get(this.binding.getService());
    }

    public OrbConfig getOrbConfig() {
        return this.orbConfig;
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType ref) throws IOException {
        return new CorbaServerConduit(this.endpointInfo, this.reference, this.obj, this.orb, this.orbConfig, this.typeMap);
    }

    public BindingInfo getBindingInfo() {
        return this.binding;
    }

    public EndpointInfo getEndPointInfo() {
        return this.endpointInfo;
    }

    public CorbaTypeMap getCorbaTypeMap() {
        return this.typeMap;
    }

    public void shutdown() {
        if (this.orb != null) {
            try {
                CorbaBindingHelper.destroyORB(this.getDestinationAddress(), this.orb);
            }
            catch (Exception ex) {
                throw new CorbaBindingException(ex);
            }
            this.orb = null;
        }
    }

    protected ORB getOrb() {
        return this.orb;
    }

    protected AddressType getAddressType() {
        return this.address;
    }

    public synchronized void setMessageObserver(MessageObserver observer) {
        if (observer != this.incomingObserver) {
            MessageObserver old = this.incomingObserver;
            this.incomingObserver = observer;
            if (observer != null) {
                if (old == null) {
                    this.activate();
                }
            } else if (old != null) {
                this.deactivate();
            }
        }
    }

    public void activate() {
        String location = this.getDestinationAddress();
        LOG.info("Service address retrieved: " + location);
        this.orb = CorbaBindingHelper.getAddressSpecificORB(location);
        if (this.orb == null) {
            LOG.log(Level.INFO, "Creating ORB with address " + location);
            this.orb = CorbaBindingHelper.createAddressSpecificORB(location, this.orbConfig);
        }
        CorbaBindingHelper.keepORBAlive(location);
        try {
            POA rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
            POAManager poaManager = rootPOA.the_POAManager();
            try {
                this.bindingPOA = rootPOA.find_POA("BindingPOA", true);
            }
            catch (AdapterNonExistent ex) {
                Policy[] policies = new Policy[this.orbConfig.isPersistentPoa() ? 3 : 2];
                policies[0] = rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID);
                policies[1] = rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION);
                if (this.orbConfig.isPersistentPoa()) {
                    policies[2] = rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
                }
                this.bindingPOA = rootPOA.create_POA("BindingPOA", poaManager, policies);
            }
            if (this.bindingPOA == null) {
                throw new CorbaBindingException("Unable to create CXF CORBA Binding POA");
            }
            CorbaDSIServant servant = new CorbaDSIServant();
            servant.init(this.orb, this.bindingPOA, this, this.incomingObserver, this.typeMap);
            this.objectId = this.bindingPOA.activate_object((Servant)servant);
            this.obj = this.bindingPOA.id_to_reference(this.objectId);
            if (location.startsWith("relfile:")) {
                URI iorFile = new URI(location.substring(3));
                CorbaUtils.exportObjectReferenceToFile(this.obj, this.orb, iorFile);
            } else if (location.startsWith("file:")) {
                URI uri = new URI(location);
                CorbaUtils.exportObjectReferenceToFile(this.obj, this.orb, uri);
            } else if (location.startsWith("corbaloc")) {
                this.addKeyToBootManager(location, this.obj);
            } else if (location.startsWith("corbaname")) {
                this.addKeyToNameservice(location, this.obj);
            } else {
                String ior = this.orb.object_to_string(this.obj);
                this.address.setLocation(ior);
                URI uri = new URI("endpoint.ior");
                CorbaUtils.exportObjectReferenceToFile(this.obj, this.orb, uri);
            }
            this.populateEpr(this.orb.object_to_string(this.obj));
            LOG.info("Object Reference: " + this.orb.object_to_string(this.obj));
            poaManager.activate();
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Unable to activate CORBA servant", ex);
        }
    }

    private void addKeyToNameservice(String location, Object ref) throws Exception {
        int idx = location.indexOf("#");
        String name = location.substring(idx + 1);
        Object nsObj = this.orb.resolve_initial_references("NameService");
        NamingContextExt rootContext = NamingContextExtHelper.narrow((Object)nsObj);
        NameComponent[] nc = rootContext.to_name(name);
        rootContext.rebind(nc, ref);
    }

    private void populateEpr(String ior) {
        AttributedURIType addr = new AttributedURIType();
        addr.setValue(ior);
        this.reference.setAddress(addr);
    }

    public String getDestinationAddress() {
        String location = null;
        if (this.endpointInfo != null) {
            location = this.endpointInfo.getAddress();
        }
        if (location == null) {
            location = this.address.getLocation();
        }
        return location;
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }

    public void deactivate() {
        if (this.orb != null) {
            if (this.bindingPOA == null) {
                throw new CorbaBindingException("Corba Port deactivation failed because the poa is null");
            }
            try {
                this.bindingPOA.deactivate_object(this.objectId);
            }
            catch (Exception ex) {
                throw new CorbaBindingException("Unable to deactivate CORBA servant", ex);
            }
        }
    }

    private void addKeyToBootManager(String location, Object value) {
        int keyIndex = location.indexOf(47);
        String key = location.substring(keyIndex + 1);
        try {
            Class<?> bootMgrHelperClass = Class.forName("org.apache.yoko.orb.OB.BootManagerHelper");
            Class<?> bootMgrClass = Class.forName("org.apache.yoko.orb.OB.BootManager");
            Method narrowMethod = bootMgrHelperClass.getMethod("narrow", Object.class);
            java.lang.Object bootMgr = narrowMethod.invoke(null, this.orb.resolve_initial_references("BootManager"));
            Method addBindingMethod = bootMgrClass.getMethod("add_binding", byte[].class, Object.class);
            addBindingMethod.invoke(bootMgr, key.getBytes(), value);
            LOG.info("Added key " + key + " to bootmanager");
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (Exception ex) {
            throw new CorbaBindingException(ex);
        }
    }
}

