/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.interceptors;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.runtime.CorbaStreamReader;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.binding.corba.types.HandlerIterator;
import org.apache.cxf.binding.corba.types.ParameterEventProducer;
import org.apache.cxf.binding.corba.types.WrappedParameterSequenceEventProducer;
import org.apache.cxf.binding.corba.utils.ContextUtils;
import org.apache.cxf.binding.corba.utils.CorbaAnyHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.wsdl.ModeType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.omg.CORBA.Any;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ServerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaStreamInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private ORB orb;
    private ServiceInfo service;
    private CorbaDestination destination;

    public CorbaStreamInInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        this.destination = message.getDestination() != null ? (CorbaDestination)message.getDestination() : (CorbaDestination)message.getExchange().getDestination();
        this.service = this.destination.getBindingInfo().getService();
        if (ContextUtils.isRequestor(message)) {
            this.handleReply(message);
        } else {
            this.handleRequest(message);
        }
    }

    private void handleReply(Message msg) {
        CorbaMessage message = (CorbaMessage)msg;
        if (message.getStreamableException() != null || message.getSystemException() != null) {
            Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
            message.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage((Message)message);
                return;
            }
        }
        CorbaMessage outMessage = (CorbaMessage)message.getExchange().getOutMessage();
        this.orb = (ORB)message.getExchange().get(ORB.class);
        HandlerIterator paramIterator = new HandlerIterator(outMessage, false);
        CorbaTypeEventProducer eventProducer = null;
        Exchange exchange = message.getExchange();
        BindingOperationInfo bindingOpInfo = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        BindingMessageInfo msgInfo = bindingOpInfo.getOutput();
        boolean wrap = false;
        if (bindingOpInfo.isUnwrappedCapable()) {
            wrap = true;
        }
        if (wrap) {
            QName wrapperElementQName = msgInfo.getMessageInfo().getName();
            eventProducer = new WrappedParameterSequenceEventProducer(wrapperElementQName, paramIterator, this.service, this.orb);
        } else {
            eventProducer = new ParameterEventProducer(paramIterator, this.service, this.orb);
        }
        CorbaStreamReader reader = new CorbaStreamReader(eventProducer);
        message.setContent(XMLStreamReader.class, reader);
    }

    private void handleRequest(Message msg) {
        CorbaMessage message = (CorbaMessage)msg;
        Exchange exchange = message.getExchange();
        CorbaTypeMap typeMap = message.getCorbaTypeMap();
        BindingInfo bInfo = this.destination.getBindingInfo();
        InterfaceInfo info = bInfo.getInterface();
        String opName = (String)exchange.get(String.class);
        Iterator i = bInfo.getOperations().iterator();
        OperationType opType = null;
        BindingOperationInfo bopInfo = null;
        QName opQName = null;
        while (i.hasNext()) {
            bopInfo = (BindingOperationInfo)i.next();
            if (!bopInfo.getName().getLocalPart().equals(opName)) continue;
            opType = (OperationType)((Object)bopInfo.getExtensor(OperationType.class));
            opQName = bopInfo.getName();
            break;
        }
        if (opType == null) {
            throw new RuntimeException("Couldn't find the binding operation for " + opName);
        }
        this.orb = (ORB)exchange.get(ORB.class);
        ServerRequest request = (ServerRequest)exchange.get(ServerRequest.class);
        NVList list = this.prepareArguments(message, info, opType, opQName, typeMap);
        request.arguments(list);
        message.setList(list);
        HandlerIterator paramIterator = new HandlerIterator(message, true);
        CorbaTypeEventProducer eventProducer = null;
        BindingMessageInfo msgInfo = bopInfo.getInput();
        boolean wrap = false;
        if (bopInfo.isUnwrappedCapable()) {
            wrap = true;
        }
        if (wrap) {
            QName wrapperElementQName = msgInfo.getMessageInfo().getName();
            eventProducer = new WrappedParameterSequenceEventProducer(wrapperElementQName, paramIterator, this.service, this.orb);
        } else {
            eventProducer = new ParameterEventProducer(paramIterator, this.service, this.orb);
        }
        CorbaStreamReader reader = new CorbaStreamReader(eventProducer);
        message.setContent(XMLStreamReader.class, reader);
    }

    protected NVList prepareArguments(CorbaMessage corbaMsg, InterfaceInfo info, OperationType opType, QName opQName, CorbaTypeMap typeMap) {
        BindingInfo bInfo = this.destination.getBindingInfo();
        EndpointInfo eptInfo = this.destination.getEndPointInfo();
        BindingOperationInfo bOpInfo = bInfo.getOperation(opQName);
        OperationInfo opInfo = bOpInfo.getOperationInfo();
        Exchange exg = corbaMsg.getExchange();
        exg.put(BindingInfo.class, (Object)bInfo);
        exg.put(InterfaceInfo.class, (Object)info);
        exg.put(EndpointInfo.class, (Object)eptInfo);
        exg.put(EndpointReferenceType.class, (Object)this.destination.getAddress());
        exg.put(ServiceInfo.class, (Object)this.service);
        exg.put(BindingOperationInfo.class, (Object)bOpInfo);
        exg.put(OperationInfo.class, (Object)opInfo);
        exg.put(MessageInfo.class, (Object)opInfo.getInput());
        exg.put(String.class, (Object)opQName.getLocalPart());
        exg.setInMessage((Message)corbaMsg);
        corbaMsg.put(MessageInfo.class, opInfo.getInput());
        List<ParamType> paramTypes = opType.getParam();
        CorbaStreamable[] arguments = new CorbaStreamable[paramTypes.size()];
        NVList list = this.prepareDIIArgsList(corbaMsg, bOpInfo, arguments, paramTypes, typeMap);
        return list;
    }

    protected NVList prepareDIIArgsList(CorbaMessage corbaMsg, BindingOperationInfo boi, CorbaStreamable[] streamables, List<ParamType> paramTypes, CorbaTypeMap map) {
        try {
            NVList list = this.orb.create_list(streamables.length);
            OperationInfo opInfo = boi.getOperationInfo();
            MessageInfo input = opInfo.getInput();
            MessageInfo output = opInfo.getOutput();
            String inWrapNSUri = null;
            String outWrapNSUri = null;
            boolean wrap = false;
            if (boi.isUnwrappedCapable()) {
                wrap = true;
                if (input != null && !CorbaUtils.isElementFormQualified(this.service, inWrapNSUri = this.getWrappedParamNamespace(input))) {
                    inWrapNSUri = "";
                }
                if (output != null && !CorbaUtils.isElementFormQualified(this.service, outWrapNSUri = this.getWrappedParamNamespace(output))) {
                    outWrapNSUri = "";
                }
            }
            int inMsgIndex = 0;
            int outMsgIndex = 0;
            for (int i = 0; i < paramTypes.size(); ++i) {
                QName paramName;
                ParamType param = paramTypes.get(i);
                QName paramIdlType = param.getIdltype();
                ModeType paramMode = param.getMode();
                if (paramMode.value().equals("in")) {
                    if (wrap) {
                        paramName = new QName(inWrapNSUri, param.getName());
                    } else {
                        paramName = this.getMessageParamQName(input, param.getName(), inMsgIndex);
                        ++inMsgIndex;
                    }
                } else if (wrap) {
                    paramName = new QName(outWrapNSUri, param.getName());
                } else {
                    paramName = this.getMessageParamQName(output, param.getName(), outMsgIndex);
                    ++outMsgIndex;
                }
                CorbaObjectHandler obj = CorbaHandlerUtils.initializeObjectHandler(this.orb, paramName, paramIdlType, map, this.service);
                streamables[i] = corbaMsg.createStreamableObject(obj, paramName);
                Any value = CorbaAnyHelper.createAny(this.orb);
                if (paramMode.value().equals("in")) {
                    streamables[i].setMode(1);
                    streamables[i].getObject().setIntoAny(value, streamables[i], false);
                } else if (paramMode.value().equals("out")) {
                    streamables[i].setMode(2);
                    streamables[i].getObject().setIntoAny(value, streamables[i], true);
                } else {
                    streamables[i].setMode(3);
                    streamables[i].getObject().setIntoAny(value, streamables[i], false);
                }
                list.add_value(streamables[i].getName(), value, streamables[i].getMode());
                corbaMsg.addStreamableArgument(streamables[i]);
            }
            return list;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected QName getMessageParamQName(MessageInfo msgInfo, String paramName, int index) {
        MessagePartInfo part = (MessagePartInfo)msgInfo.getMessageParts().get(index);
        QName paramQName = part != null && part.isElement() ? part.getElementQName() : part.getName();
        return paramQName;
    }

    protected String getWrappedParamNamespace(MessageInfo msgInfo) {
        MessagePartInfo part = (MessagePartInfo)msgInfo.getMessageParts().get(0);
        if (part.isElement()) {
            return part.getElementQName().getNamespaceURI();
        }
        return part.getName().getNamespaceURI();
    }
}

