/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSServiceFactoryBean.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private List<Object> resourceObjects;

    public JAXRSInvoker() {
    }

    public JAXRSInvoker(List<Object> resourceObjects) {
        this.resourceObjects = resourceObjects;
    }

    public Object invoke(Exchange exchange, Object request) {
        return this.invoke(exchange, request, this.resourceObjects);
    }

    public Object invoke(Exchange exchange, Object request, List<Object> resources) {
        Response response = (Response)exchange.get(Response.class);
        if (response != null) {
            return new MessageContentsList(new Object[]{response});
        }
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Object resourceObject = this.getServiceObject(exchange, resources);
        Method methodToInvoke = InjectionUtils.checkProxy(cri.getMethodDispatcher().getMethod(ori), resourceObject);
        if (cri.isRoot()) {
            JAXRSUtils.handleSetters(cri, resourceObject, exchange.getInMessage());
            InjectionUtils.injectContextFields(resourceObject, ori.getClassResourceInfo(), exchange.getInMessage());
            InjectionUtils.injectResourceFields(resourceObject, ori.getClassResourceInfo(), exchange.getInMessage());
        }
        List params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)((List)request));
        } else if (request != null) {
            params = new MessageContentsList(new Object[]{request});
        }
        Object result = null;
        try {
            result = this.invoke(exchange, resourceObject, methodToInvoke, params);
        }
        catch (Fault ex) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause());
            if (excResponse == null) {
                ProviderFactory.getInstance().cleatThreadLocalProxies();
                ClassResourceInfo criRoot = (ClassResourceInfo)exchange.get((Object)"root.resource.class");
                if (criRoot != null) {
                    criRoot.clearThreadLocalProxies();
                }
                throw ex;
            }
            return new MessageContentsList(new Object[]{excResponse});
        }
        if (ori.isSubResourceLocator()) {
            if (result != null) {
                if (result instanceof MessageContentsList) {
                    result = ((MessageContentsList)result).get(0);
                } else if (result instanceof List) {
                    result = ((List)result).get(0);
                } else if (result.getClass().isArray()) {
                    result = ((Object[])result)[0];
                }
            }
            ArrayList<Object> newResourceObjects = new ArrayList<Object>();
            newResourceObjects.add(result);
            Message msg = exchange.getInMessage();
            MetadataMap<String, String> values = new MetadataMap<String, String>();
            String subResourcePath = (String)msg.get((Object)"relative.path");
            String httpMethod = (String)msg.get((Object)Message.HTTP_REQUEST_METHOD);
            String contentType = (String)msg.get((Object)"Content-Type");
            if (contentType == null) {
                contentType = "*/*";
            }
            List acceptContentType = (List)msg.getExchange().get((Object)"Accept");
            ClassResourceInfo subCri = JAXRSUtils.findSubResourceClass(cri, result.getClass());
            if (subCri == null) {
                org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, new Object[]{subResourcePath});
                LOG.severe(errorM.toString());
                throw new Fault(errorM);
            }
            OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(subCri, subResourcePath, httpMethod, values, contentType, acceptContentType);
            if (subOri == null) {
                org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_METHOD_FOUND", BUNDLE, new Object[]{subCri.getResourceClass().getSimpleName()});
                LOG.severe(errorM.toString());
                throw new Fault(errorM);
            }
            exchange.put(OperationResourceInfo.class, (Object)subOri);
            msg.put((Object)"relative.path", values.getFirst("FINAL_MATCH_GROUP"));
            msg.put((Object)"jaxrs.template.parameters", values);
            List<Object> newParams = JAXRSUtils.processParameters(subOri, values, msg);
            msg.setContent(List.class, newParams);
            return this.invoke(exchange, newParams, newResourceObjects);
        }
        return result;
    }

    public Object getServiceObject(Exchange exchange) {
        return this.getServiceObject(exchange, this.resourceObjects);
    }

    public Object getServiceObject(Exchange exchange, List<Object> resources) {
        Object serviceObject = null;
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        if (resources != null) {
            Class<?> c = cri.getResourceClass();
            for (Object resourceObject : resources) {
                if (!c.isInstance(resourceObject)) continue;
                serviceObject = resourceObject;
            }
        }
        if (serviceObject == null) {
            serviceObject = cri.getResourceProvider().getInstance();
        }
        return serviceObject;
    }
}

