/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils {
    static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();
    static DocumentBuilder builder;

    private DOMUtils() {
    }

    private static synchronized DocumentBuilder getBuilder() throws ParserConfigurationException {
        if (builder == null) {
            FACTORY.setNamespaceAware(true);
            builder = FACTORY.newDocumentBuilder();
        }
        return builder;
    }

    public static String getContent(Node n) {
        if (n == null) {
            return null;
        }
        Node n1 = DOMUtils.getChild(n, 3);
        if (n1 == null) {
            return null;
        }
        return n1.getNodeValue().trim();
    }

    public static String getRawContent(Node n) {
        if (n == null) {
            return null;
        }
        Node n1 = DOMUtils.getChild(n, 3);
        if (n1 == null) {
            return null;
        }
        return n1.getNodeValue();
    }

    public static Node getChild(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        Node first = parent.getFirstChild();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            if (name != null && name.equals(node.getNodeName())) {
                return node;
            }
            if (name != null) continue;
            return node;
        }
        return null;
    }

    public static String getAttribute(Node element, String attName) {
        NamedNodeMap attrs = element.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node attN = attrs.getNamedItem(attName);
        if (attN == null) {
            return null;
        }
        return attN.getNodeValue();
    }

    public static String getAttribute(Element element, QName attName) {
        return element.getAttributeNS(attName.getNamespaceURI(), attName.getLocalPart());
    }

    public static void setAttribute(Node node, String attName, String val) {
        NamedNodeMap attributes = node.getAttributes();
        Attr attNode = node.getOwnerDocument().createAttribute(attName);
        attNode.setNodeValue(val);
        attributes.setNamedItem(attNode);
    }

    public static void removeAttribute(Node node, String attName) {
        NamedNodeMap attributes = node.getAttributes();
        attributes.removeNamedItem(attName);
    }

    public static void setText(Node node, String val) {
        Node chld = DOMUtils.getChild(node, 3);
        if (chld == null) {
            Text textN = node.getOwnerDocument().createTextNode(val);
            node.appendChild(textN);
            return;
        }
        chld.setNodeValue(val);
    }

    public static Node findChildWithAtt(Node parent, String elemName, String attName, String attVal) {
        Node child = DOMUtils.getChild(parent, 1);
        if (attVal == null) {
            while (child != null && (elemName == null || elemName.equals(child.getNodeName())) && DOMUtils.getAttribute(child, attName) != null) {
                child = DOMUtils.getNext(child, elemName, 1);
            }
        } else {
            while (child != null && (elemName == null || elemName.equals(child.getNodeName())) && !attVal.equals(DOMUtils.getAttribute(child, attName))) {
                child = DOMUtils.getNext(child, elemName, 1);
            }
        }
        return child;
    }

    public static String getChildContent(Node parent, String name) {
        Node first = parent.getFirstChild();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            return DOMUtils.getContent(node);
        }
        return null;
    }

    public static QName getElementQName(Element el) {
        return new QName(el.getNamespaceURI(), el.getLocalName());
    }

    public static Element getFirstElement(Node parent) {
        Node n;
        for (n = parent.getFirstChild(); n != null && 1 != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }

    public static Element getFirstChildWithName(Element parent, QName q) {
        String ns = q.getNamespaceURI();
        String lp = q.getLocalPart();
        return DOMUtils.getFirstChildWithName(parent, ns, lp);
    }

    public static Element getFirstChildWithName(Element parent, String ns, String lp) {
        Node n;
        for (n = parent.getFirstChild(); n != null && !ns.equals(n.getNamespaceURI()) && !lp.equals(n.getLocalName()); n = n.getNextSibling()) {
        }
        return (Element)n;
    }

    public static Node getChild(Node parent, int type) {
        Node n;
        for (n = parent.getFirstChild(); n != null && type != n.getNodeType(); n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return n;
    }

    public static Node getNext(Node current) {
        String name = current.getNodeName();
        short type = current.getNodeType();
        return DOMUtils.getNext(current, name, type);
    }

    public static Node getNext(Node current, String name, int type) {
        Node first = current.getNextSibling();
        if (first == null) {
            return null;
        }
        for (Node node = first; node != null; node = node.getNextSibling()) {
            if (type >= 0 && node.getNodeType() != type) continue;
            if (name == null) {
                return node;
            }
            if (!name.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    public static Document readXml(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        return db.parse(is);
    }

    public static Document readXml(StreamSource is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        InputSource is2 = new InputSource();
        is2.setSystemId(is.getSystemId());
        is2.setByteStream(is.getInputStream());
        is2.setCharacterStream(is.getReader());
        return db.parse(is2);
    }

    public static void writeXml(Node n, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(n), new StreamResult(os));
    }

    public static DocumentBuilder createDocumentBuilder() {
        try {
            return FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Couldn't find a DOM parser.", e);
        }
    }

    public static Document createDocument() {
        try {
            return DOMUtils.getBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Couldn't find a DOM parser.", e);
        }
    }

    public static String getUniquePrefix(Element el, String ns) {
        return null;
    }

    public static String getPrefixRecursive(Element el, String ns) {
        String prefix = DOMUtils.getPrefix(el, ns);
        if (prefix == null && el.getParentNode() instanceof Element) {
            prefix = DOMUtils.getPrefixRecursive((Element)el.getParentNode(), ns);
        }
        return prefix;
    }

    public static String getPrefix(Element el, String ns) {
        NamedNodeMap atts = el.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node node = atts.item(i);
            String name = node.getNodeName();
            if (!ns.equals(node.getNodeValue()) || name == null || !"xmlns".equals(name) && !name.startsWith("xmlns:")) continue;
            return node.getPrefix();
        }
        return null;
    }

    public static String createNamespace(Element el, String ns) {
        String p = "ns1";
        int i = 1;
        while (DOMUtils.getPrefix(el, ns) != null) {
            p = "ns" + i;
            ++i;
        }
        el.setAttribute("xmlns:" + p, ns);
        return p;
    }

    public static String getNamespace(Element el, String pre) {
        NamedNodeMap atts = el.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node node = atts.item(i);
            String name = node.getLocalName();
            String pre2 = node.getPrefix();
            if (pre.equals(name) && "xmlns".equals(pre2)) {
                return node.getNodeValue();
            }
            if (pre.length() != 0 || !"xmlns".equals(name) || pre2.length() != 0) continue;
            return node.getNodeValue();
        }
        Node parent = el.getParentNode();
        if (parent instanceof Element) {
            return DOMUtils.getNamespace((Element)parent, pre);
        }
        return null;
    }

    public static class NullResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

