/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectivePolicyImpl
implements EffectivePolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EffectivePolicyImpl.class);
    private static final Logger LOG = LogUtils.getL7dLogger(EffectivePolicyImpl.class);
    protected Policy policy;
    protected Collection<PolicyAssertion> chosenAlternative;
    protected List<Interceptor> interceptors;

    @Override
    public Policy getPolicy() {
        return this.policy;
    }

    @Override
    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public Collection<PolicyAssertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    void initialise(EndpointPolicyImpl epi, PolicyEngineImpl engine) {
        this.policy = epi.getPolicy();
        this.chosenAlternative = epi.getChosenAlternative();
        this.initialiseInterceptors(engine);
    }

    void initialise(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, Assertor assertor, boolean requestor) {
        this.initialisePolicy(ei, boi, engine, requestor);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine);
    }

    void initialise(EndpointInfo ei, BindingFaultInfo bfi, PolicyEngineImpl engine, Assertor assertor) {
        this.initialisePolicy(ei, bfi, engine);
        this.chooseAlternative(engine, assertor);
        this.initialiseInterceptors(engine);
    }

    void initialisePolicy(EndpointInfo ei, BindingOperationInfo boi, PolicyEngineImpl engine, boolean requestor) {
        BindingMessageInfo bmi = requestor ? boi.getInput() : boi.getOutput();
        this.policy = requestor ? engine.getClientEndpointPolicy(ei, null).getPolicy() : engine.getServerEndpointPolicy(ei, null).getPolicy();
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        if (null != bmi) {
            this.policy = this.policy.merge(engine.getAggregatedMessagePolicy(bmi));
        }
        this.policy = (Policy)this.policy.normalize(true);
    }

    void initialisePolicy(EndpointInfo ei, BindingFaultInfo bfi, PolicyEngineImpl engine) {
        BindingOperationInfo boi = bfi.getBindingOperation();
        this.policy = engine.getServerEndpointPolicy(ei, null).getPolicy();
        this.policy = this.policy.merge(engine.getAggregatedOperationPolicy(boi));
        this.policy = this.policy.merge(engine.getAggregatedFaultPolicy(bfi));
        this.policy = (Policy)this.policy.normalize(true);
    }

    void chooseAlternative(PolicyEngineImpl engine, Assertor assertor) {
        Collection<PolicyAssertion> alternative = engine.getAlternativeSelector().selectAlternative(this.policy, engine, assertor);
        if (null == alternative) {
            PolicyUtils.logPolicy(LOG, Level.FINE, "No alternative supported.", (PolicyComponent)this.getPolicy());
            throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    void initialiseInterceptors(PolicyEngineImpl engine) {
        PolicyInterceptorProviderRegistry reg = engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        ArrayList<Interceptor> out = new ArrayList<Interceptor>();
        for (PolicyAssertion a : this.getChosenAlternative()) {
            QName qn;
            PolicyInterceptorProvider pp;
            if (a.isOptional() || null == (pp = (PolicyInterceptorProvider)reg.get(qn = a.getName()))) continue;
            out.addAll(pp.getOutInterceptors());
        }
        this.setInterceptors(out);
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<PolicyAssertion> c) {
        this.chosenAlternative = c;
    }

    void setInterceptors(List<Interceptor> out) {
        this.interceptors = out;
    }
}

