/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuedTokenBuilder
implements AssertionBuilder {
    private static final String WSA_NAMESPACE_SUB = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.ISSUED_TOKEN, SP12Constants.ISSUED_TOKEN);
    PolicyBuilder builder;

    public IssuedTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        Element policyElement;
        Element rstTmplElem;
        Element issuerElem;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        IssuedToken issuedToken = new IssuedToken(consts);
        String includeAttr = DOMUtils.getAttribute((Element)element, (QName)consts.getIncludeToken());
        if (includeAttr != null) {
            issuedToken.setInclusion(consts.getInclusionFromAttributeValue(includeAttr));
        }
        if ((issuerElem = DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.ISSUER)) != null) {
            Element issuerEpr = DOMUtils.getFirstChildWithName((Element)issuerElem, (QName)new QName(WSA_NAMESPACE, "Address"));
            if (issuerEpr == null) {
                issuerEpr = DOMUtils.getFirstChildWithName((Element)issuerElem, (QName)new QName(WSA_NAMESPACE_SUB, "Address"));
            }
            issuedToken.setIssuerEpr(issuerEpr);
        }
        if (issuerElem != null) {
            Element issuerMex = DOMUtils.getFirstChildWithName((Element)issuerElem, (QName)new QName(WSA_NAMESPACE, "Metadata"));
            if (issuerMex == null) {
                issuerMex = DOMUtils.getFirstChildWithName((Element)issuerElem, (QName)new QName(WSA_NAMESPACE_SUB, "Metadata"));
            }
            issuedToken.setIssuerMex(issuerMex);
        }
        if ((rstTmplElem = DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.REQUEST_SECURITY_TOKEN_TEMPLATE)) != null) {
            issuedToken.setRstTemplate(rstTmplElem);
        }
        if ((policyElement = DOMUtils.getFirstChildWithName((Element)element, (QName)Constants.Q_ELEM_POLICY)) != null) {
            Policy policy = this.builder.getPolicy(policyElement);
            Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), issuedToken);
            }
        }
        return issuedToken;
    }

    private void processAlternative(List assertions, IssuedToken parent) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (SP11Constants.REQUIRE_DERIVED_KEYS.equals(name)) {
                parent.setDerivedKeys(true);
                continue;
            }
            if (SP11Constants.REQUIRE_EXTERNAL_REFERNCE.equals(name)) {
                parent.setRequireExternalReference(true);
                continue;
            }
            if (!SP11Constants.REQUIRE_INTERNAL_REFERNCE.equals(name)) continue;
            parent.setRequireInternalReference(true);
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

