/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.AnnotationInterceptors;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.context.WebServiceContextResourceResolver;
import org.apache.cxf.jaxws.handler.AnnotationHandlerChainBuilder;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServerFactoryBean
extends ServerFactoryBean {
    protected boolean doInit;
    protected List<Handler> handlers = new ArrayList<Handler>();

    public JaxWsServerFactoryBean() {
        this(new JaxWsServiceFactoryBean());
    }

    public JaxWsServerFactoryBean(JaxWsServiceFactoryBean serviceFactory) {
        super((ReflectionServiceFactoryBean)serviceFactory);
        JaxWsSoapBindingConfiguration defConfig = new JaxWsSoapBindingConfiguration(serviceFactory);
        this.setBindingConfig((BindingConfiguration)defConfig);
        this.doInit = true;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers.clear();
        this.handlers.addAll(h);
    }

    public void addHandlers(List<Handler> h) {
        this.handlers.addAll(h);
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    protected void initializeAnnotationInterceptors(Endpoint ep, Class<?> cls) {
        Class<?> seiClass = ((JaxWsServiceFactoryBean)this.getServiceFactory()).getJaxWsImplementorInfo().getSEIClass();
        AnnotationInterceptors provider = seiClass != null ? new AnnotationInterceptors(new Class[]{cls, seiClass}) : new AnnotationInterceptors(new Class[]{cls});
        this.initializeAnnotationInterceptors(provider, ep);
    }

    protected Invoker createInvoker() {
        return new JAXWSMethodInvoker(this.getServiceBean());
    }

    protected BindingInfo createBindingInfo() {
        JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        JaxWsImplementorInfo implInfo = sf.getJaxWsImplementorInfo();
        String jaxBid = implInfo.getBindingType();
        String binding = this.getBindingId();
        if (binding == null) {
            binding = jaxBid;
            this.setBindingId(binding);
        }
        if (binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
            binding = "http://schemas.xmlsoap.org/wsdl/soap/";
            this.setBindingId(binding);
            if (this.getBindingConfig() == null) {
                this.setBindingConfig((BindingConfiguration)new JaxWsSoapBindingConfiguration(sf));
            }
        } else if (binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            binding = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
            this.setBindingId(binding);
            if (this.getBindingConfig() == null) {
                this.setBindingConfig((BindingConfiguration)new JaxWsSoapBindingConfiguration(sf));
            }
        }
        if (this.getBindingConfig() instanceof JaxWsSoapBindingConfiguration) {
            JaxWsSoapBindingConfiguration conf = (JaxWsSoapBindingConfiguration)this.getBindingConfig();
            if (jaxBid.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                conf.setVersion((SoapVersion)Soap12.getInstance());
            }
            if (jaxBid.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
                conf.setVersion((SoapVersion)Soap12.getInstance());
                conf.setMtomEnabled(true);
            }
            if (jaxBid.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
                conf.setMtomEnabled(true);
            }
            conf.setJaxWsServiceFactoryBean(sf);
        }
        BindingInfo bindingInfo = super.createBindingInfo();
        if (implInfo.isWebServiceProvider()) {
            bindingInfo.setProperty("databinding.disabled", (Object)Boolean.TRUE);
        }
        return bindingInfo;
    }

    public Server create() {
        Server server = super.create();
        this.init();
        return server;
    }

    private synchronized void init() {
        if (this.doInit) {
            try {
                this.injectResources(this.getServiceBean());
                this.buildHandlerChain();
            }
            catch (Exception ex) {
                if (ex instanceof WebServiceException) {
                    throw (WebServiceException)ex;
                }
                throw new WebServiceException("Creation of Endpoint failed", (Throwable)ex);
            }
        }
        this.doInit = false;
    }

    private void buildHandlerChain() {
        AnnotationHandlerChainBuilder builder = new AnnotationHandlerChainBuilder();
        JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        ArrayList<Handler> chain = new ArrayList<Handler>(this.handlers);
        chain.addAll(builder.buildHandlerChainFromClass(this.getServiceBeanClass(), sf.getEndpointInfo().getName(), sf.getServiceQName(), this.getBindingId()));
        for (Handler h : chain) {
            this.injectResources(h);
        }
        ((JaxWsEndpointImpl)this.getServer().getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
    }

    protected void injectResources(Object instance) {
        if (instance != null) {
            ResourceManager resourceManager = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
            List resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            resourceManager.addResourceResolver((ResourceResolver)new WebServiceContextResourceResolver());
            ResourceInjector injector = new ResourceInjector(resourceManager);
            if (Proxy.isProxyClass(instance.getClass()) && this.getServiceClass() != null) {
                injector.inject(instance, this.getServiceClass());
                injector.construct(instance, this.getServiceClass());
            } else {
                injector.inject(instance);
                injector.construct(instance);
            }
        }
    }
}

