/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.wsdl.BindingType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ServerRequest;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.POA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaDSIServant
extends DynamicImplementation {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaDSIServant.class);
    private ORB orb;
    private POA servantPOA;
    private List<String> interfaces;
    private MessageObserver incomingObserver;
    private CorbaDestination destination;
    private Map<String, QName> operationMap;
    private CorbaTypeMap typeMap;

    public void init(ORB theOrb, POA poa, CorbaDestination dest, MessageObserver observer) {
        this.init(theOrb, poa, dest, observer, null);
    }

    public void init(ORB theOrb, POA poa, CorbaDestination dest, MessageObserver observer, CorbaTypeMap map) {
        this.orb = theOrb;
        this.servantPOA = poa;
        this.destination = dest;
        this.incomingObserver = observer;
        this.typeMap = map;
        try {
            BindingType bindType = this.destination.getBindingInfo().getExtensor(BindingType.class);
            if (bindType == null) {
                throw new CorbaBindingException("Unable to determine corba binding information");
            }
            List<String> bases = bindType.getBases();
            this.interfaces = new ArrayList<String>();
            this.interfaces.add(bindType.getRepositoryID());
            Iterator<String> iter = bases.iterator();
            while (iter.hasNext()) {
                this.interfaces.add(iter.next());
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Couldn't initialize the corba DSI servant");
            throw new CorbaBindingException(ex);
        }
        BindingInfo bInfo = this.destination.getBindingInfo();
        Iterator<BindingOperationInfo> i = bInfo.getOperations().iterator();
        this.operationMap = new HashMap<String, QName>(bInfo.getOperations().size());
        while (i.hasNext()) {
            BindingOperationInfo bopInfo = i.next();
            OperationType opType = bopInfo.getExtensor(OperationType.class);
            if (opType == null) continue;
            this.operationMap.put(opType.getName(), bopInfo.getName());
        }
    }

    protected MessageObserver getObserver() {
        return this.incomingObserver;
    }

    protected void setObserver(MessageObserver observer) {
        this.incomingObserver = observer;
    }

    protected ORB getOrb() {
        return this.orb;
    }

    public CorbaDestination getDestination() {
        return this.destination;
    }

    public Map<String, QName> getOperationMapping() {
        return this.operationMap;
    }

    public void setOperationMapping(Map<String, QName> map) {
        this.operationMap = map;
    }

    public void setCorbaTypeMap(CorbaTypeMap map) {
        this.typeMap = map;
    }

    public void invoke(ServerRequest request) throws CorbaBindingException {
        MessageImpl msgImpl = new MessageImpl();
        msgImpl.setDestination(this.getDestination());
        ExchangeImpl exg = new ExchangeImpl();
        exg.put(String.class, this.operationMap.get(request.operation()).getLocalPart());
        exg.put(ORB.class, this.getOrb());
        exg.put(ServerRequest.class, request);
        msgImpl.setExchange(exg);
        CorbaMessage msg = new CorbaMessage(msgImpl);
        msg.setCorbaTypeMap(this.typeMap);
        this.getObserver().onMessage(msg);
    }

    public String[] _all_interfaces(POA poa, byte[] objectId) {
        return this.interfaces.toArray(new String[this.interfaces.size()]);
    }

    public POA _default_POA() {
        return this.servantPOA;
    }
}

