/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private MultivaluedMap<String, String> templateParams;
    private Message message;

    public UriInfoImpl(Message m, MultivaluedMap<String, String> templateParams) {
        this.message = m;
        this.templateParams = templateParams;
    }

    public URI getAbsolutePath() {
        String address = this.getEndpointAddress();
        address = address.endsWith("/") ? address.substring(0, address.length() - 1) : address;
        return URI.create(address + this.getPath());
    }

    public UriBuilder getAbsolutePathBuilder() {
        return new UriBuilderImpl(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        return URI.create(this.getEndpointAddress());
    }

    public UriBuilder getBaseUriBuilder() {
        return new UriBuilderImpl(this.getBaseUri());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        String path = (String)this.message.get(Message.PATH_INFO);
        return decode ? JAXRSUtils.uriDecode(path) : path;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return JAXRSUtils.getPathSegments(this.getPath(), decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return JAXRSUtils.getStructuredParams((String)this.message.get(Message.QUERY_STRING), "&", decode);
    }

    public URI getRequestUri() {
        String queries = (String)this.message.get(Message.QUERY_STRING);
        return URI.create(this.getEndpointAddress() + this.message.get(Message.PATH_INFO) + (queries == null ? "" : "?" + queries));
    }

    public UriBuilder getRequestUriBuilder() {
        return new UriBuilderImpl(this.getRequestUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        for (Map.Entry entry : this.templateParams.entrySet()) {
            if (((String)entry.getKey()).equals("FINAL_MATCH_GROUP")) continue;
            values.add((String)entry.getKey(), decode ? JAXRSUtils.uriDecode((String)((List)entry.getValue()).get(0)) : (String)((List)entry.getValue()).get(0));
        }
        return values;
    }

    protected String getEndpointAddress() {
        String value = this.message.getExchange().getDestination().getAddress().getAddress().getValue();
        return value;
    }

    public List<String> getAncestorResourceURIs() {
        return null;
    }

    public List<Object> getAncestorResources() {
        return null;
    }

    public List<String> getAncestorResourceURIs(boolean arg0) {
        return null;
    }

    public String getPathExtension() {
        return null;
    }

    public UriBuilder getPlatonicRequestUriBuilder() {
        return null;
    }
}

