/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSProviderHub;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.JMSTransport;
import org.apache.cxf.transport.jms.JMSTransportBase;
import org.apache.cxf.transport.jms.PooledSession;
import org.apache.cxf.transport.jms.ServerBehaviorPolicyType;
import org.apache.cxf.transport.jms.ServerConfig;
import org.apache.cxf.transport.jms.SessionPoolType;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public class JMSDestination
extends AbstractMultiplexDestination
implements Configurable,
JMSTransport {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".jms-destination-base";
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    protected ServerConfig serverConfig;
    protected ServerBehaviorPolicyType runtimePolicy;
    protected AddressType address;
    protected SessionPoolType sessionPool;
    final ConduitInitiator conduitInitiator;
    final JMSTransportBase base;
    PooledSession listenerSession;
    JMSListenerThread listenerThread;

    public JMSDestination(Bus b, ConduitInitiator ci, EndpointInfo info) throws IOException {
        super(b, JMSDestination.getTargetReference(info, b), info);
        this.base = new JMSTransportBase(b, this.endpointInfo, true, BASE_BEAN_NAME_SUFFIX, this);
        this.conduitInitiator = ci;
        this.initConfig();
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(org.apache.cxf.message.Message inMessage) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), inMessage);
    }

    public void activate() {
        this.getLogger().log(Level.INFO, "JMSServerTransport activate().... ");
        try {
            this.getLogger().log(Level.FINE, "establishing JMS connection");
            JMSProviderHub.connect(this, this.serverConfig, this.runtimePolicy);
            this.listenerSession = this.base.sessionFactory.get(this.base.targetDestination);
            this.listenerThread = new JMSListenerThread(this.listenerSession);
            this.listenerThread.start();
        }
        catch (JMSException ex) {
            this.getLogger().log(Level.SEVERE, "JMS connect failed with JMSException : ", ex);
        }
        catch (NamingException nex) {
            this.getLogger().log(Level.SEVERE, "JMS connect failed with NamingException : ", nex);
        }
    }

    public void deactivate() {
        try {
            this.listenerSession.consumer().close();
            if (this.listenerThread != null) {
                this.listenerThread.join();
            }
            this.base.sessionFactory.shutdown();
        }
        catch (InterruptedException e) {
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.getLogger().log(Level.FINE, "JMSDestination shutdown()");
        this.deactivate();
    }

    public Queue getReplyToDestination(org.apache.cxf.message.Message inMessage) throws JMSException, NamingException {
        Message message = (Message)inMessage.get("org.apache.cxf.jms.request.message");
        Queue replyTo = inMessage.get("org.apache.cxf.jms.server.replyto") != null ? this.base.sessionFactory.getQueueFromInitialContext((String)inMessage.get("org.apache.cxf.jms.server.replyto")) : (null != message.getJMSReplyTo() ? (Queue)message.getJMSReplyTo() : (Queue)this.base.replyDestination);
        return replyTo;
    }

    public void setReplyCorrelationID(Message request, Message reply) throws JMSException {
        String correlationID = request.getJMSCorrelationID();
        if (correlationID == null || "".equals(correlationID) && this.getRuntimePolicy().isUseMessageIDAsCorrelationID()) {
            correlationID = request.getJMSMessageID();
        }
        if (correlationID != null && !"".equals(correlationID)) {
            reply.setJMSCorrelationID(correlationID);
        }
    }

    protected void incoming(Message message) throws IOException {
        try {
            this.getLogger().log(Level.FINE, "server received request: ", message);
            Object request = this.base.unmarshal(message);
            this.getLogger().log(Level.FINE, "The Request Message is [ " + request + "]");
            byte[] bytes = null;
            if (message instanceof TextMessage) {
                String requestString = (String)request;
                this.getLogger().log(Level.FINE, "server received request: ", requestString);
                bytes = requestString.getBytes();
            } else {
                bytes = (byte[])request;
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(bytes));
            this.base.populateIncomingContext(message, inMessage, "org.apache.cxf.jms.server.request.headers");
            inMessage.put("org.apache.cxf.jms.server.response.headers", new JMSMessageHeadersType());
            inMessage.put("org.apache.cxf.jms.request.message", message);
            inMessage.setDestination(this);
            BusFactory.setThreadDefaultBus(this.bus);
            this.incomingObserver.onMessage(inMessage);
        }
        catch (JMSException jmsex) {
            throw new IOException(jmsex.getMessage());
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public void connected(Destination target, Destination reply, JMSSessionFactory factory) {
        this.base.connected(target, reply, factory);
    }

    public String getBeanName() {
        return this.endpointInfo.getName().toString() + ".jms-destination";
    }

    private void initConfig() {
        this.runtimePolicy = this.endpointInfo.getTraversedExtensor(new ServerBehaviorPolicyType(), ServerBehaviorPolicyType.class);
        this.serverConfig = this.endpointInfo.getTraversedExtensor(new ServerConfig(), ServerConfig.class);
        this.address = this.endpointInfo.getTraversedExtensor(new AddressType(), AddressType.class);
        this.sessionPool = this.endpointInfo.getTraversedExtensor(new SessionPoolType(), SessionPoolType.class);
        Configurer configurer = this.base.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(this);
        }
    }

    public AddressType getJMSAddress() {
        return this.address;
    }

    public void setJMSAddress(AddressType a) {
        this.address = a;
    }

    public ServerBehaviorPolicyType getRuntimePolicy() {
        return this.runtimePolicy;
    }

    public void setRuntimePolicy(ServerBehaviorPolicyType runtimePolicy) {
        this.runtimePolicy = runtimePolicy;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public SessionPoolType getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionPool(SessionPoolType sessionPool) {
        this.sessionPool = sessionPool;
    }

    private class JMSOutputStream
    extends CachedOutputStream {
        private org.apache.cxf.message.Message inMessage;
        private org.apache.cxf.message.Message outMessage;
        private Message reply;
        private Queue replyTo;
        private QueueSender sender;

        public JMSOutputStream(org.apache.cxf.message.Message m, org.apache.cxf.message.Message o) {
            this.inMessage = m;
            this.outMessage = o;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void commitOutputMessage() throws IOException {
            headers = (JMSMessageHeadersType)this.outMessage.get("org.apache.cxf.jms.server.response.headers");
            request = (Message)this.inMessage.get("org.apache.cxf.jms.request.message");
            replySession = null;
            if (JMSDestination.this.base.isDestinationStyleQueue()) {
                try {
                    this.replyTo = JMSDestination.this.getReplyToDestination(this.inMessage);
                    replySession = JMSDestination.this.base.sessionFactory.get(false);
                    this.sender = (QueueSender)replySession.producer();
                    msgType = "text";
                    replyObj /* !! */  = null;
                    if (request instanceof TextMessage) {
                        builder = new StringBuilder();
                        this.writeCacheTo(builder);
                        replyObj /* !! */  = (byte[])builder.toString();
                        msgType = "text";
                    } else if (request instanceof BytesMessage) {
                        replyObj /* !! */  = this.getBytes();
                        msgType = "byte";
                    } else {
                        replyObj /* !! */  = this.getBytes();
                        msgType = "binary";
                    }
                    if (JMSDestination.this.getLogger().isLoggable(Level.FINE)) {
                        JMSDestination.this.getLogger().log(Level.FINE, "The response message is [" + (replyObj /* !! */  instanceof String != false ? (String)replyObj /* !! */  : IOUtils.newStringFromBytes(replyObj /* !! */ )) + "]");
                    }
                    this.reply = JMSDestination.this.base.marshal(replyObj /* !! */ , replySession.session(), null, msgType);
                    JMSDestination.this.setReplyCorrelationID(request, this.reply);
                    JMSDestination.this.base.setMessageProperties(headers, this.reply);
                    protHeaders = CastUtils.cast((Map)this.outMessage.get(org.apache.cxf.message.Message.PROTOCOL_HEADERS));
                    JMSDestination.this.base.addProtocolHeaders(this.reply, protHeaders);
                    this.sendResponse();
                    if (replySession == null) ** GOTO lbl46
                    JMSDestination.this.base.sessionFactory.recycle(replySession);
                }
                catch (JMSException ex) {
                    try {
                        JMSDestination.this.getLogger().log(Level.WARNING, "Failed in post dispatch ...", ex);
                        throw new IOException(ex.getMessage());
                        catch (NamingException nex) {
                            JMSDestination.this.getLogger().log(Level.WARNING, "Failed in post dispatch ...", nex);
                            throw new IOException(nex.getMessage());
                        }
                    }
                    catch (Throwable var7_9) {
                        if (replySession != null) {
                            JMSDestination.this.base.sessionFactory.recycle(replySession);
                        }
                        throw var7_9;
                    }
                }
            } else {
                JMSDestination.this.getLogger().log(Level.WARNING, "discarding reply for non-oneway invocation ", "with 'topic' destinationStyle");
            }
lbl46:
            // 3 sources

            JMSDestination.this.getLogger().log(Level.FINE, "just server sending reply: ", this.reply);
        }

        private void sendResponse() throws JMSException {
            JMSMessageHeadersType headers = (JMSMessageHeadersType)this.inMessage.get("org.apache.cxf.jms.server.request.headers");
            Message request = (Message)this.inMessage.get("org.apache.cxf.jms.request.message");
            int deliveryMode = JMSDestination.this.base.getJMSDeliveryMode(headers);
            int priority = JMSDestination.this.base.getJMSPriority(headers);
            long ttl = JMSDestination.this.base.getTimeToLive(headers);
            if (ttl <= 0L) {
                ttl = JMSDestination.this.getServerConfig().getMessageTimeToLive();
            }
            long timeToLive = 0L;
            if (request.getJMSExpiration() > 0L) {
                SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
                GregorianCalendar cal = new GregorianCalendar(tz);
                timeToLive = request.getJMSExpiration() - cal.getTimeInMillis();
            }
            if (timeToLive >= 0L) {
                ttl = ttl > 0L ? ttl : timeToLive;
                JMSDestination.this.getLogger().log(Level.FINE, "send out the message!");
                this.sender.send(this.replyTo, this.reply, deliveryMode, priority, ttl);
            } else {
                JMSDestination.this.getLogger().log(Level.INFO, "Message time to live is already expired skipping response.");
            }
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected org.apache.cxf.message.Message inMessage;

        BackChannelConduit(EndpointReferenceType ref, org.apache.cxf.message.Message message) {
            super(ref);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(org.apache.cxf.message.Message message) throws IOException {
            message.put("org.apache.cxf.jms.request.message", this.inMessage.get("org.apache.cxf.jms.request.message"));
            if (!message.containsKey("org.apache.cxf.jms.server.response.headers") && this.inMessage.containsKey("org.apache.cxf.jms.server.response.headers")) {
                message.put("org.apache.cxf.jms.server.response.headers", this.inMessage.get("org.apache.cxf.jms.server.response.headers"));
            }
            message.setContent(OutputStream.class, new JMSOutputStream(this.inMessage, message));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }

    protected class JMSExecutor
    implements Runnable {
        Message message;

        JMSExecutor(Message m) {
            this.message = m;
        }

        public void run() {
            JMSDestination.this.getLogger().log(Level.INFO, "run the incoming message in the threadpool");
            try {
                JMSDestination.this.incoming(this.message);
            }
            catch (IOException ex) {
                JMSDestination.this.getLogger().log(Level.WARNING, "Failed to process incoming message : ", ex);
            }
        }
    }

    protected class JMSListenerThread
    extends Thread {
        private final PooledSession listenSession;

        public JMSListenerThread(PooledSession session) {
            this.listenSession = session;
        }

        public void run() {
            try {
                block7: while (true) {
                    Message message;
                    if ((message = this.listenSession.consumer().receive()) == null) {
                        JMSDestination.this.getLogger().log(Level.WARNING, "Null message received from message consumer.", " Exiting ListenerThread::run().");
                        return;
                    }
                    while (true) {
                        WorkQueueManager wqm;
                        if (message == null) continue block7;
                        Executor executor = null;
                        if (executor == null && null != (wqm = JMSDestination.this.base.bus.getExtension(WorkQueueManager.class))) {
                            executor = wqm.getAutomaticWorkQueue();
                        }
                        if (executor != null) {
                            try {
                                executor.execute(new JMSExecutor(message));
                                message = null;
                            }
                            catch (RejectedExecutionException ree) {}
                        } else {
                            JMSDestination.this.getLogger().log(Level.INFO, "handle the incoming message in listener thread");
                            try {
                                JMSDestination.this.incoming(message);
                            }
                            catch (IOException ex) {
                                JMSDestination.this.getLogger().log(Level.WARNING, "Failed to process incoming message : ", ex);
                            }
                        }
                        message = null;
                    }
                    break;
                }
            }
            catch (JMSException jmsex) {
                jmsex.printStackTrace();
                JMSDestination.this.getLogger().log(Level.SEVERE, "Exiting ListenerThread::run(): ", jmsex.getMessage());
            }
            catch (Throwable jmsex) {
                jmsex.printStackTrace();
                JMSDestination.this.getLogger().log(Level.SEVERE, "Exiting ListenerThread::run(): ", jmsex.getMessage());
            }
        }
    }
}

