/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebFault;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.interceptors.SystemExceptionHelper;
import org.apache.cxf.binding.corba.runtime.CorbaFaultStreamWriter;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.RaisesType;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.SystemException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaStreamFaultOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaStreamFaultOutInterceptor.class);
    private ORB orb;

    public CorbaStreamFaultOutInterceptor() {
        super("marshal");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Message msg) {
        MessagePartInfo partInfo;
        CorbaMessage message = (CorbaMessage)msg;
        Exchange exchange = message.getExchange();
        Fault faultEx = null;
        CorbaDestination destination = message.getDestination() != null ? (CorbaDestination)message.getDestination() : (CorbaDestination)exchange.getDestination();
        this.orb = (ORB)message.get("orb");
        if (this.orb == null) {
            this.orb = (ORB)exchange.get(ORB.class);
        }
        DataWriter<XMLStreamWriter> writer = this.getDataWriter(message);
        Throwable ex = (Throwable)message.getContent(Exception.class);
        if (ex.getCause() == null) {
            if (!(ex instanceof Fault) || ((Fault)ex).getDetail() == null) throw new CorbaBindingException(ex);
            faultEx = (Fault)ex;
        } else {
            ex = ex.getCause();
        }
        if (ex instanceof InvocationTargetException) {
            ex = ex.getCause();
        }
        if (ex instanceof SystemException) {
            this.setSystemException(message, ex);
            return;
        }
        String exClassName = null;
        if (faultEx == null) {
            WebFault fault = ex.getClass().getAnnotation(WebFault.class);
            if (fault == null) {
                throw new CorbaBindingException(ex);
            }
            exClassName = fault.name();
        } else {
            Element faultElement = (Element)faultEx.getDetail().getFirstChild();
            exClassName = faultElement.getLocalName();
        }
        BindingInfo bInfo = destination.getBindingInfo();
        String opName = (String)message.getExchange().get(String.class);
        Iterator iter = bInfo.getOperations().iterator();
        BindingOperationInfo bopInfo = null;
        OperationType opType = null;
        while (iter.hasNext()) {
            bopInfo = (BindingOperationInfo)iter.next();
            if (!bopInfo.getName().getLocalPart().equals(opName)) continue;
            opType = (OperationType)((Object)bopInfo.getExtensor(OperationType.class));
            break;
        }
        if (opType == null) {
            throw new CorbaBindingException("Unable to find binding operation for " + opName);
        }
        OperationInfo opInfo = bopInfo.getOperationInfo();
        if (faultEx != null && (partInfo = this.getFaultMessagePartInfo(opInfo, new QName("", exClassName))) != null) {
            exClassName = partInfo.getTypeQName().getLocalPart();
        }
        RaisesType exType = this.getRaisesType(opType, exClassName, ex);
        try {
            if (exType == null) throw new CorbaBindingException(ex);
            if (faultEx != null) {
                this.setUserExceptionFromFaultDetail(message, faultEx.getDetail(), exType, opInfo, writer, (ServiceInfo)exchange.get(ServiceInfo.class));
                return;
            } else {
                this.setUserException(message, ex, exType, opInfo, writer, (ServiceInfo)exchange.get(ServiceInfo.class));
            }
            return;
        }
        catch (Exception exp) {
            throw new CorbaBindingException(exp);
        }
    }

    protected RaisesType getRaisesType(OperationType opType, String exClassName, Throwable ex) {
        RaisesType result = null;
        List<RaisesType> exList = opType.getRaises();
        result = this.findRaisesType(exList, exClassName);
        if (result == null) {
            try {
                Method faultMethod = ex.getClass().getMethod("getFaultInfo", new Class[0]);
                if (faultMethod != null) {
                    Class<?> faultClass = faultMethod.getReturnType();
                    XmlType exType = faultClass.getAnnotation(XmlType.class);
                    exClassName = exType.name();
                    result = this.findRaisesType(exList, exClassName);
                }
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        return result;
    }

    protected RaisesType findRaisesType(List<RaisesType> exList, String exClassName) {
        RaisesType result = null;
        for (RaisesType raises : exList) {
            if (!raises.getException().getLocalPart().equals(exClassName)) continue;
            result = raises;
            break;
        }
        return result;
    }

    protected void setSystemException(CorbaMessage message, Throwable ex) {
        SystemException sysEx = (SystemException)ex;
        message.setSystemException(sysEx);
        ServerRequest request = (ServerRequest)message.getExchange().get(ServerRequest.class);
        Any exAny = this.orb.create_any();
        SystemExceptionHelper.insert(exAny, sysEx);
        request.set_exception(exAny);
    }

    protected void setUserException(CorbaMessage message, Throwable ex, RaisesType exType, OperationInfo opInfo, DataWriter<XMLStreamWriter> writer, ServiceInfo service) throws Exception {
        QName exIdlType = exType.getException();
        QName elName = new QName("", exIdlType.getLocalPart());
        MessagePartInfo faultPart = this.getFaultMessagePartInfo(opInfo, elName);
        if (faultPart == null) {
            throw new CorbaBindingException("Coulnd't find the message fault part : " + elName);
        }
        Method faultMethod = ex.getClass().getMethod("getFaultInfo", new Class[0]);
        if (faultMethod == null) {
            return;
        }
        Object fault = faultMethod.invoke((Object)ex, new Object[0]);
        if (fault == null) {
            Class<?> faultClass = faultMethod.getReturnType();
            fault = faultClass.newInstance();
        }
        CorbaFaultStreamWriter faultWriter = new CorbaFaultStreamWriter(this.orb, exType, message.getCorbaTypeMap(), service);
        writer.write(fault, faultPart, (Object)faultWriter);
        CorbaObjectHandler[] objs = faultWriter.getCorbaObjects();
        CorbaStreamable streamable = message.createStreamableObject(objs[0], elName);
        message.setStreamableException(streamable);
    }

    protected void setUserExceptionFromFaultDetail(CorbaMessage message, Element faultDetail, RaisesType exType, OperationInfo opInfo, DataWriter<XMLStreamWriter> writer, ServiceInfo service) throws Exception {
        QName exIdlType = exType.getException();
        QName elName = new QName("", exIdlType.getLocalPart());
        MessagePartInfo faultPart = this.getFaultMessagePartInfo(opInfo, elName);
        Object fault = this.extractPartsInfoFromDetail((Element)faultDetail.getFirstChild(), exType);
        CorbaFaultStreamWriter faultWriter = new CorbaFaultStreamWriter(this.orb, exType, message.getCorbaTypeMap(), service);
        writer.write(fault, faultPart, (Object)faultWriter);
        CorbaObjectHandler[] objs = faultWriter.getCorbaObjects();
        CorbaStreamable streamable = message.createStreamableObject(objs[0], elName);
        message.setStreamableException(streamable);
    }

    private Object extractPartsInfoFromDetail(Element faultDetail, RaisesType exType) {
        Document faultDoc = DOMUtils.createDocument();
        Element faultElement = faultDoc.createElement(exType.getException().getLocalPart());
        faultDoc.appendChild(faultElement);
        NodeList nodeList = faultDetail.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node importedFaultData = faultDoc.importNode(nodeList.item(i), true);
            faultElement.appendChild(importedFaultData);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Exception DOM: " + XMLUtils.toString((Node)faultElement));
        }
        return faultDoc;
    }

    protected DataWriter<XMLStreamWriter> getDataWriter(CorbaMessage message) {
        Service serviceModel = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataWriter dataWriter = serviceModel.getDataBinding().createWriter(XMLStreamWriter.class);
        if (dataWriter == null) {
            throw new CorbaBindingException("Couldn't create data writer for outgoing fault message");
        }
        return dataWriter;
    }

    protected MessagePartInfo getFaultMessagePartInfo(OperationInfo opInfo, QName faultName) {
        for (FaultInfo fault : opInfo.getFaults()) {
            MessagePartInfo partInfo = (MessagePartInfo)fault.getMessageParts().get(0);
            if (partInfo.isElement() && partInfo.getElementQName().getLocalPart().equals(faultName.getLocalPart())) {
                return partInfo;
            }
            if (!partInfo.getTypeQName().getLocalPart().equals(faultName.getLocalPart())) continue;
            return partInfo;
        }
        return null;
    }
}

