/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.extension.BusExtension;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurerImpl
extends BeanConfigurerSupport
implements Configurer,
ApplicationContextAware,
BusExtension {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurerImpl.class);
    private Set<ApplicationContext> appContexts;
    private final Map<String, String> wildCardBeanDefinitions = new HashMap<String, String>();

    public ConfigurerImpl() {
    }

    public ConfigurerImpl(ApplicationContext ac) {
        this.setApplicationContext(ac);
    }

    private void initWildcardDefinitionMap() {
        if (null != this.appContexts) {
            for (ApplicationContext appContext : this.appContexts) {
                for (String n : appContext.getBeanDefinitionNames()) {
                    if (!this.isWildcardBeanName(n)) continue;
                    AutowireCapableBeanFactory bf = appContext.getAutowireCapableBeanFactory();
                    BeanDefinitionRegistry bdr = (BeanDefinitionRegistry)bf;
                    BeanDefinition bd = bdr.getBeanDefinition(n);
                    String className = bd.getBeanClassName();
                    if (null != className) {
                        if (!this.wildCardBeanDefinitions.containsKey(className)) {
                            this.wildCardBeanDefinitions.put(className, n);
                            continue;
                        }
                        LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"ONE_WILDCARD_BEAN_ID_PER_CLASS_MSG", (Object[])new String[]{this.wildCardBeanDefinitions.get(className), className, n});
                        continue;
                    }
                    LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"WILDCARD_BEAN_ID_WITH_NO_CLASS_MSG", (Object)n);
                }
            }
        }
    }

    public void configureBean(Object beanInstance) {
        this.configureBean(null, beanInstance);
    }

    public synchronized void configureBean(String bn, Object beanInstance) {
        block7: {
            if (null == this.appContexts) {
                return;
            }
            if (null == bn) {
                bn = this.getBeanName(beanInstance);
            }
            if (null == bn) {
                return;
            }
            this.configureWithWildCard(bn, beanInstance);
            final String beanName = bn;
            this.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

                public BeanWiringInfo resolveWiringInfo(Object instance) {
                    if (null != beanName && !"".equals(beanName)) {
                        return new BeanWiringInfo(beanName);
                    }
                    return null;
                }
            });
            for (ApplicationContext appContext : this.appContexts) {
                if (!appContext.containsBean(bn)) continue;
                this.setBeanFactory((BeanFactory)appContext.getAutowireCapableBeanFactory());
            }
            try {
                super.configureBean(beanInstance);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Successfully performed injection.");
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "NO_MATCHING_BEAN_MSG", beanName);
            }
        }
    }

    private void configureWithWildCard(String bn, Object beanInstance) {
        String wildCardBeanId;
        String className;
        if (!this.wildCardBeanDefinitions.isEmpty() && !this.isWildcardBeanName(bn) && this.wildCardBeanDefinitions.containsKey(className = beanInstance.getClass().getName()) && bn.endsWith(this.stripStar(wildCardBeanId = this.wildCardBeanDefinitions.get(className)))) {
            this.configureBean(wildCardBeanId, beanInstance);
        }
    }

    private boolean isWildcardBeanName(String bn) {
        return bn.charAt(0) == '*';
    }

    private String stripStar(String wildCardBeanId) {
        return wildCardBeanId.substring(1);
    }

    protected String getBeanName(Object beanInstance) {
        if (beanInstance instanceof Configurable) {
            return ((Configurable)beanInstance).getBeanName();
        }
        String beanName = null;
        Method m = null;
        try {
            m = beanInstance.getClass().getDeclaredMethod("getBeanName", null);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = beanInstance.getClass().getMethod("getBeanName", null);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                beanName = (String)m.invoke(beanInstance, new Object[0]);
            }
            catch (Exception ex) {
                LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"ERROR_DETERMINING_BEAN_NAME_EXC", (Throwable)ex);
            }
        }
        if (null == beanName) {
            LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"COULD_NOT_DETERMINE_BEAN_NAME_MSG", (Object)beanInstance.getClass().getName());
        }
        return beanName;
    }

    public final void setApplicationContext(ApplicationContext ac) {
        this.appContexts = new CopyOnWriteArraySet<ApplicationContext>();
        this.addApplicationContext(ac);
        this.setBeanFactory((BeanFactory)ac.getAutowireCapableBeanFactory());
    }

    public final void addApplicationContext(ApplicationContext ac) {
        if (!this.appContexts.contains(ac)) {
            this.appContexts.add(ac);
            this.initWildcardDefinitionMap();
        }
    }

    public Class<?> getRegistrationType() {
        return Configurer.class;
    }
}

