/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor;
import org.apache.cxf.ws.policy.ClientPolicyInInterceptor;
import org.apache.cxf.ws.policy.ClientPolicyOutInterceptor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.PolicyRegistryImpl;
import org.apache.cxf.ws.policy.PolicyVerificationInFaultInterceptor;
import org.apache.cxf.ws.policy.PolicyVerificationInInterceptor;
import org.apache.cxf.ws.policy.PolicyVerificationOutInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyInInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutInterceptor;
import org.apache.cxf.ws.policy.selector.MinimalAlternativeSelector;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyEngineImpl
implements PolicyEngine,
BusExtension {
    private static final String POLICY_INFO_REQUEST_SERVER = "policy-engine-info-serve-request";
    private static final String POLICY_INFO_FAULT_SERVER = "policy-engine-info-serve-fault";
    private static final String POLICY_INFO_RESPONSE_SERVER = "policy-engine-info-serve-response";
    private static final String POLICY_INFO_ENDPOINT_SERVER = "policy-engine-info-serve-rendpoint";
    private static final String POLICY_INFO_REQUEST_CLIENT = "policy-engine-info-client-request";
    private static final String POLICY_INFO_FAULT_CLIENT = "policy-engine-info-client-fault";
    private static final String POLICY_INFO_RESPONSE_CLIENT = "policy-engine-info-client-response";
    private static final String POLICY_INFO_ENDPOINT_CLIENT = "policy-engine-info-client-endpoint";
    private Bus bus;
    private PolicyRegistry registry;
    private Collection<PolicyProvider> policyProviders;
    private boolean enabled;
    private boolean ignoreUnknownAssertions;
    private boolean addedBusInterceptors;
    private AlternativeSelector alternativeSelector;

    public PolicyEngineImpl() {
        this.init();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setPolicyProviders(Collection<PolicyProvider> p) {
        this.policyProviders = p;
    }

    public Collection<PolicyProvider> getPolicyProviders() {
        return this.policyProviders;
    }

    public void setRegistry(PolicyRegistry r) {
        this.registry = r;
    }

    public PolicyRegistry getRegistry() {
        return this.registry;
    }

    public synchronized void setEnabled(boolean e) {
        this.enabled = e;
        if (!this.addedBusInterceptors) {
            this.addBusInterceptors();
        }
    }

    public AlternativeSelector getAlternativeSelector() {
        return this.alternativeSelector;
    }

    public void setAlternativeSelector(AlternativeSelector as) {
        this.alternativeSelector = as;
    }

    public boolean isIgnoreUnknownAssertions() {
        return this.ignoreUnknownAssertions;
    }

    public void setIgnoreUnknownAssertions(boolean ignore) {
        this.ignoreUnknownAssertions = ignore;
    }

    public Class<?> getRegistrationType() {
        return PolicyEngine.class;
    }

    public EffectivePolicy getEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, Conduit c) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (c instanceof Assertor) {
                assertor = (Assertor)c;
            }
            epi.initialise(ei, boi, this, assertor, true);
            boi.setProperty(POLICY_INFO_REQUEST_CLIENT, (Object)epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    public void setEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_REQUEST_CLIENT, (Object)ep);
    }

    public EffectivePolicy getEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, Destination d) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)d;
            }
            epi.initialise(ei, boi, this, assertor, false);
            boi.setProperty(POLICY_INFO_RESPONSE_SERVER, (Object)epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    public void setEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_RESPONSE_SERVER, (Object)ep);
    }

    public EffectivePolicy getEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, Destination d) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = null;
            if (d instanceof Assertor) {
                assertor = (Assertor)d;
            }
            epi.initialise(ei, bfi, this, assertor);
            bfi.setProperty(POLICY_INFO_FAULT_SERVER, (Object)epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    public void setEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        bfi.setProperty(POLICY_INFO_FAULT_SERVER, (Object)ep);
    }

    public EndpointPolicy getClientEndpointPolicy(EndpointInfo ei, Conduit conduit) {
        Assertor assertor = conduit instanceof Assertor ? (Assertor)conduit : null;
        return this.getEndpointPolicy(ei, true, assertor);
    }

    public EndpointPolicy getServerEndpointPolicy(EndpointInfo ei, Destination destination) {
        Assertor assertor = destination instanceof Assertor ? (Assertor)destination : null;
        return this.getEndpointPolicy(ei, false, assertor);
    }

    private EndpointPolicy getEndpointPolicy(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        EndpointPolicy ep = (EndpointPolicy)ei.getProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER);
        if (null != ep) {
            return ep;
        }
        return this.createEndpointPolicyInfo(ei, isRequestor, assertor);
    }

    public void setClientEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        ei.setProperty(POLICY_INFO_ENDPOINT_CLIENT, (Object)ep);
    }

    public void setServerEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        ei.setProperty(POLICY_INFO_ENDPOINT_SERVER, (Object)ep);
    }

    public EffectivePolicy getEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_SERVER);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, boi, this, false);
            boi.setProperty(POLICY_INFO_REQUEST_SERVER, (Object)epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    public void setEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_REQUEST_SERVER, (Object)ep);
    }

    public EffectivePolicy getEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, boi, this, true);
            boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, (Object)epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    public void setEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, (Object)ep);
    }

    public EffectivePolicy getEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_CLIENT);
        if (null == effectivePolicy) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            epi.initialisePolicy(ei, bfi, this);
            bfi.setProperty(POLICY_INFO_FAULT_CLIENT, (Object)epi);
            effectivePolicy = epi;
        }
        return effectivePolicy;
    }

    public void setEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        bfi.setProperty(POLICY_INFO_FAULT_CLIENT, (Object)ep);
    }

    protected final void init() {
        this.registry = new PolicyRegistryImpl();
    }

    @PostConstruct
    public void addBusInterceptors() {
        if (null == this.alternativeSelector) {
            this.alternativeSelector = new MinimalAlternativeSelector();
        }
        if (null == this.bus || !this.enabled) {
            return;
        }
        AssertionBuilderRegistry abr = (AssertionBuilderRegistry)this.bus.getExtension(AssertionBuilderRegistry.class);
        if (null != abr) {
            abr.setIgnoreUnknownAssertions(this.ignoreUnknownAssertions);
        }
        ClientPolicyOutInterceptor clientOut = new ClientPolicyOutInterceptor();
        clientOut.setBus(this.bus);
        this.bus.getOutInterceptors().add(clientOut);
        ClientPolicyInInterceptor clientIn = new ClientPolicyInInterceptor();
        clientIn.setBus(this.bus);
        this.bus.getInInterceptors().add(clientIn);
        ClientPolicyInFaultInterceptor clientInFault = new ClientPolicyInFaultInterceptor();
        clientInFault.setBus(this.bus);
        this.bus.getInFaultInterceptors().add(clientInFault);
        ServerPolicyInInterceptor serverIn = new ServerPolicyInInterceptor();
        serverIn.setBus(this.bus);
        this.bus.getInInterceptors().add(serverIn);
        ServerPolicyOutInterceptor serverOut = new ServerPolicyOutInterceptor();
        serverOut.setBus(this.bus);
        this.bus.getOutInterceptors().add(serverOut);
        ServerPolicyOutFaultInterceptor serverOutFault = new ServerPolicyOutFaultInterceptor();
        serverOutFault.setBus(this.bus);
        this.bus.getOutFaultInterceptors().add(serverOutFault);
        PolicyVerificationOutInterceptor verifyOut = new PolicyVerificationOutInterceptor();
        verifyOut.setBus(this.bus);
        this.bus.getOutInterceptors().add(verifyOut);
        PolicyVerificationInInterceptor verifyIn = new PolicyVerificationInInterceptor();
        verifyIn.setBus(this.bus);
        this.bus.getInInterceptors().add(verifyIn);
        PolicyVerificationInFaultInterceptor verifyInFault = new PolicyVerificationInFaultInterceptor();
        verifyInFault.setBus(this.bus);
        this.bus.getInFaultInterceptors().add(verifyInFault);
        this.addedBusInterceptors = true;
    }

    Policy getAggregatedServicePolicy(ServiceInfo si) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(si);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedEndpointPolicy(EndpointInfo ei) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(ei);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedOperationPolicy(BindingOperationInfo boi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(boi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedMessagePolicy(BindingMessageInfo bmi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bmi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedFaultPolicy(BindingFaultInfo bfi) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bfi);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Collection<PolicyAssertion> getAssertions(PolicyComponent pc, boolean includeOptional) {
        ArrayList<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>();
        if (5 == pc.getType()) {
            PolicyAssertion a = (PolicyAssertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add(a);
            }
        } else {
            this.addAssertions(pc, includeOptional, assertions);
        }
        return assertions;
    }

    void addAssertions(PolicyComponent pc, boolean includeOptional, Collection<PolicyAssertion> assertions) {
        if (5 == pc.getType()) {
            PolicyAssertion a = (PolicyAssertion)pc;
            if (includeOptional || !a.isOptional()) {
                assertions.add((PolicyAssertion)pc);
            }
            return;
        }
        if (4 == pc.getType()) {
            PolicyReference pr = (PolicyReference)pc;
            pc = pr.normalize(this.registry, false);
        }
        PolicyOperator po = (PolicyOperator)pc;
        List pcs = CastUtils.cast((List)po.getPolicyComponents(), PolicyComponent.class);
        for (PolicyComponent child : pcs) {
            this.addAssertions(child, includeOptional, assertions);
        }
    }

    Set<QName> getVocabulary(PolicyComponent pc, boolean includeOptional) {
        Collection<PolicyAssertion> assertions = this.getAssertions(pc, includeOptional);
        HashSet<QName> vocabulary = new HashSet<QName>();
        for (PolicyAssertion a : assertions) {
            vocabulary.add(a.getName());
        }
        return vocabulary;
    }

    EndpointPolicyImpl createEndpointPolicyInfo(EndpointInfo ei, boolean isRequestor, Assertor assertor) {
        EndpointPolicyImpl epi = new EndpointPolicyImpl(ei, this, isRequestor, assertor);
        epi.initialize();
        ei.setProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER, (Object)epi);
        return epi;
    }

    public boolean supportsAlternative(Collection<PolicyAssertion> alternative, Assertor assertor) {
        PolicyInterceptorProviderRegistry pipr = (PolicyInterceptorProviderRegistry)this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        for (PolicyAssertion a : alternative) {
            if (a.isOptional() || null != pipr.get((Object)a.getName()) || null != assertor && assertor.canAssert(a.getName())) continue;
            return false;
        }
        return true;
    }

    EffectivePolicyImpl createOutPolicyInfo() {
        return new EffectivePolicyImpl();
    }
}

