/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;

@ManagedResource(componentName="Endpoint", description="Responsible for managing server instances.")
public class ManagedEndpoint
implements ManagedComponent,
ServerLifeCycleListener {
    private Bus bus;
    private Endpoint endpoint;
    private Server server;
    private State state = State.CREATED;

    public ManagedEndpoint(Bus b, Endpoint ep, Server s) {
        this.bus = b;
        this.endpoint = ep;
        this.server = s;
    }

    @ManagedOperation
    public void start() {
        if (this.state == State.STARTED) {
            return;
        }
        ServerLifeCycleManager mgr = this.bus.getExtension(ServerLifeCycleManager.class);
        if (mgr != null) {
            mgr.registerListener(this);
        }
        this.server.start();
    }

    @ManagedOperation
    public void stop() {
        this.server.stop();
    }

    @ManagedAttribute(description="Address Attribute", currencyTimeLimit=60)
    public String getAddress() {
        return this.endpoint.getEndpointInfo().getAddress();
    }

    @ManagedAttribute(description="TransportId Attribute", currencyTimeLimit=60)
    public String getTransportId() {
        return this.endpoint.getEndpointInfo().getAddress();
    }

    @ManagedAttribute(description="Server State")
    public String getState() {
        return this.state.toString();
    }

    public ObjectName getObjectName() throws JMException {
        String busId = this.bus.getId();
        StringBuffer buffer = new StringBuffer();
        buffer.append("org.apache.cxf:");
        buffer.append("bus.id=" + busId + ",");
        buffer.append("type=Bus.Service.Endpoint,");
        String serviceName = ObjectName.quote(this.endpoint.getService().getName().toString());
        buffer.append("service=" + serviceName + ",");
        String endpointName = ObjectName.quote(this.endpoint.getEndpointInfo().getName().toString());
        buffer.append("port=" + endpointName);
        return new ObjectName(buffer.toString());
    }

    public void startServer(Server s) {
        if (this.server.equals(s)) {
            this.state = State.STARTED;
        }
    }

    public void stopServer(Server s) {
        if (this.server.equals(s)) {
            this.state = State.STOPPED;
            ServerLifeCycleManager mgr = this.bus.getExtension(ServerLifeCycleManager.class);
            if (mgr != null) {
                mgr.unRegisterListener(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CREATED,
        STARTED,
        STOPPED;

    }
}

