/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.corba.CorbaBinding;
import org.apache.cxf.binding.corba.CorbaConduit;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamFaultInInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamFaultOutInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamInInterceptor;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamOutInterceptor;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.BareOutInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaBindingFactory
extends AbstractBindingFactory
implements ConduitInitiator,
DestinationFactory {
    protected List<String> transportIds;
    protected OrbConfig orbConfig = new OrbConfig();

    public void setOrbClass(String cls) {
        this.orbConfig.setOrbClass(cls);
    }

    public void setOrbSingletonClass(String cls) {
        this.orbConfig.setOrbSingletonClass(cls);
    }

    public Binding createBinding(BindingInfo bindingInfo) {
        CorbaBinding binding = new CorbaBinding();
        binding.getInFaultInterceptors().add(new CorbaStreamFaultInInterceptor());
        binding.getOutFaultInterceptors().add(new CorbaStreamFaultOutInterceptor());
        binding.getOutInterceptors().add((Interceptor)new BareOutInterceptor());
        binding.getOutInterceptors().add((Interceptor)new CorbaStreamOutInterceptor());
        binding.getInInterceptors().add((Interceptor)new BareInInterceptor());
        binding.getInInterceptors().add((Interceptor)new CorbaStreamInInterceptor());
        binding.setBindingInfo(bindingInfo);
        return binding;
    }

    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, null);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        return new CorbaConduit(endpointInfo, target, this.orbConfig);
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        return new CorbaDestination(endpointInfo, this.orbConfig);
    }

    public List<String> getTransportIds() {
        return this.transportIds;
    }

    @Resource(name="transportIds")
    public void setTransportIds(List<String> ids) {
        this.transportIds = ids;
    }

    public void setOrbArgs(List<String> args) {
        this.orbConfig.setOrbArgs(args);
    }

    public Set<String> getUriPrefixes() {
        HashSet<String> uriPrefixes = new HashSet<String>();
        uriPrefixes.add("IOR");
        uriPrefixes.add("ior");
        uriPrefixes.add("file");
        uriPrefixes.add("relfile");
        uriPrefixes.add("corba");
        return uriPrefixes;
    }

    public OrbConfig getOrbConfig() {
        return this.orbConfig;
    }

    public void setOrbConfig(OrbConfig config) {
        this.orbConfig = config;
    }
}

