/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaDestination;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.TypeMapCache;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.utils.ContextUtils;
import org.apache.cxf.binding.corba.utils.CorbaAnyHelper;
import org.apache.cxf.binding.corba.utils.CorbaBindingHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.utils.OrbConfig;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.RaisesType;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnknownUserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaConduit
implements Conduit {
    private static final Logger LOG = LogUtils.getL7dLogger(CorbaConduit.class);
    private EndpointInfo endpointInfo;
    private EndpointReferenceType target;
    private MessageObserver incomingObserver;
    private ORB orb;
    private OrbConfig orbConfig;
    private CorbaTypeMap typeMap;

    public CorbaConduit(EndpointInfo ei, EndpointReferenceType ref, OrbConfig config) {
        this.endpointInfo = ei;
        this.target = this.getTargetReference(ref);
        this.orbConfig = config;
        this.typeMap = TypeMapCache.get(ei.getService());
    }

    public OrbConfig getOrbConfig() {
        return this.orbConfig;
    }

    protected synchronized void prepareOrb() {
        if (this.orb == null) {
            this.orb = CorbaBindingHelper.getDefaultORB(this.orbConfig);
        }
    }

    public void prepare(Message message) throws IOException {
        try {
            this.prepareOrb();
            AddressType address = (AddressType)((java.lang.Object)this.endpointInfo.getExtensor(AddressType.class));
            if (address == null) {
                LOG.log(Level.SEVERE, "Unable to locate a valid CORBA address");
                throw new CorbaBindingException("Unable to locate a valid CORBA address");
            }
            String ref = (String)message.get((java.lang.Object)Message.ENDPOINT_ADDRESS);
            Object targetObject = ref != null ? CorbaUtils.importObjectReference(this.orb, ref) : CorbaUtils.importObjectReference(this.orb, address.getLocation());
            message.put((java.lang.Object)"orb", (java.lang.Object)this.orb);
            message.put((java.lang.Object)"endpoint", (java.lang.Object)targetObject);
            message.setContent(OutputStream.class, (java.lang.Object)new CorbaOutputStream(message));
            CorbaMessage corbaMessage = (CorbaMessage)message;
            corbaMessage.setCorbaTypeMap(this.typeMap);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not resolve target object");
            throw new CorbaBindingException(ex);
        }
    }

    public void close(Message message) throws IOException {
        if (message.get((java.lang.Object)"endpoint") != null) {
            BindingOperationInfo boi = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
            OperationType opType = (OperationType)((java.lang.Object)boi.getExtensor(OperationType.class));
            try {
                this.buildRequest((CorbaMessage)message, opType);
                ((OutputStream)message.getContent(OutputStream.class)).close();
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Could not build the corba request");
                throw new CorbaBindingException(ex);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public EndpointReferenceType getTarget() {
        return this.target;
    }

    public Destination getBackChannel() {
        return null;
    }

    public void close() {
    }

    public void setMessageObserver(MessageObserver observer) {
        this.incomingObserver = observer;
    }

    public final EndpointReferenceType getTargetReference(EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(this.getAddress());
            ref.setAddress(address);
        } else {
            ref = t;
        }
        return ref;
    }

    public final String getAddress() {
        return this.endpointInfo.getAddress();
    }

    public void buildRequest(CorbaMessage message, OperationType opType) throws Exception {
        ServiceInfo service = (ServiceInfo)message.getExchange().get(ServiceInfo.class);
        NVList nvlist = this.getArguments(message);
        NamedValue ret = this.getReturn(message);
        Map<TypeCode, RaisesType> exceptions = this.getOperationExceptions(opType, this.typeMap);
        ExceptionList exList = this.getExceptionList(exceptions, message, opType);
        Request request = this.getRequest(message, opType.getName(), nvlist, ret, exList);
        if (request == null) {
            throw new CorbaBindingException("Couldn't build the corba request");
        }
        try {
            request.invoke();
        }
        catch (SystemException ex) {
            message.setContent(Exception.class, new Fault((Throwable)ex));
            message.setSystemException(ex);
            return;
        }
        Exception ex = request.env().exception();
        if (ex != null) {
            if (ex instanceof UnknownUserException) {
                UnknownUserException userEx = (UnknownUserException)ex;
                Any except = userEx.except;
                RaisesType raises = exceptions.get(except.type());
                if (raises == null) {
                    throw new CorbaBindingException("Couldn't find the exception type code to unmarshall");
                }
                QName elName = new QName("", raises.getException().getLocalPart());
                CorbaObjectHandler handler = CorbaHandlerUtils.initializeObjectHandler(this.orb, elName, raises.getException(), this.typeMap, service);
                CorbaStreamable exStreamable = message.createStreamableObject(handler, elName);
                exStreamable._read(except.create_input_stream());
                message.setStreamableException(exStreamable);
                message.setContent(Exception.class, new Fault((Throwable)userEx));
            } else {
                message.setContent(Exception.class, new Fault((Throwable)ex));
            }
        }
    }

    public NVList getArguments(CorbaMessage message) {
        if (this.orb == null) {
            this.prepareOrb();
        }
        NVList list = null;
        if (message.getStreamableArguments() != null) {
            CorbaStreamable[] arguments = message.getStreamableArguments();
            list = this.orb.create_list(arguments.length);
            for (CorbaStreamable argument : arguments) {
                Any value = CorbaAnyHelper.createAny(this.orb);
                argument.getObject().setIntoAny(value, argument, true);
                list.add_value(argument.getName(), value, argument.getMode());
            }
        } else {
            list = this.orb.create_list(0);
        }
        return list;
    }

    public NamedValue getReturn(CorbaMessage message) {
        if (this.orb == null) {
            this.prepareOrb();
        }
        CorbaStreamable retVal = message.getStreamableReturn();
        NamedValue ret = null;
        if (retVal != null) {
            Any returnAny = CorbaAnyHelper.createAny(this.orb);
            retVal.getObject().setIntoAny(returnAny, retVal, false);
            ret = this.orb.create_named_value(retVal.getName(), returnAny, 2);
        } else {
            ret = this.orb.create_named_value("return", this.orb.create_any(), 2);
        }
        return ret;
    }

    public ExceptionList getExceptionList(Map<TypeCode, RaisesType> exceptions, CorbaMessage message, OperationType opType) {
        if (this.orb == null) {
            this.prepareOrb();
        }
        ExceptionList exList = this.orb.create_exception_list();
        if (exceptions != null) {
            java.lang.Object[] tcs = null;
            tcs = exceptions.keySet().toArray();
            for (int i = 0; i < exceptions.size(); ++i) {
                exList.add((TypeCode)tcs[i]);
            }
        }
        return exList;
    }

    public Request getRequest(CorbaMessage message, String opName, NVList nvlist, NamedValue ret, ExceptionList exList) throws Exception {
        Request request = null;
        if (this.orb == null) {
            this.prepareOrb();
        }
        ContextList ctxList = this.orb.create_context_list();
        Context ctx = null;
        try {
            ctx = this.orb.get_default_context();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Object targetObj = (Object)message.get("endpoint");
        if (targetObj != null) {
            request = targetObj._create_request(ctx, opName, nvlist, ret, exList, ctxList);
        }
        return request;
    }

    public Map<TypeCode, RaisesType> getOperationExceptions(OperationType operation, CorbaTypeMap map) {
        if (this.orb == null) {
            this.prepareOrb();
        }
        HashMap<TypeCode, RaisesType> exceptions = new HashMap<TypeCode, RaisesType>();
        List<RaisesType> exList = operation.getRaises();
        if (exList != null) {
            for (int i = 0; i < exList.size(); ++i) {
                RaisesType ex = exList.get(i);
                TypeCode tc = CorbaUtils.getTypeCode(this.orb, ex.getException(), map);
                exceptions.put(tc, ex);
            }
        }
        return exceptions;
    }

    private class CorbaOutputStream
    extends CachedOutputStream {
        private Message message;
        private boolean isOneWay;

        CorbaOutputStream(Message m) {
            this.message = m;
        }

        public void doFlush() throws IOException {
        }

        public void doClose() throws IOException {
            if (ContextUtils.isRequestor(this.message) && ContextUtils.isOutbound(this.message)) {
                try {
                    this.isOneWay = this.message.getExchange().isOneWay();
                    if (!this.isOneWay) {
                        this.handleResponse();
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Connection failed with Exception : ", ex);
                    throw new IOException(ex.toString());
                }
            }
        }

        public void onWrite() throws IOException {
        }

        public void handleResponse() throws IOException {
            LOG.log(Level.FINE, "incoming observer is " + CorbaConduit.this.incomingObserver);
            Exchange exchange = this.message.getExchange();
            CorbaMessage corbaMsg = (CorbaMessage)this.message;
            MessageImpl inMessage = new MessageImpl();
            CorbaDestination destination = new CorbaDestination(CorbaConduit.this.endpointInfo, CorbaConduit.this.orbConfig, CorbaConduit.this.typeMap);
            inMessage.setDestination((Destination)destination);
            exchange.put(ORB.class, (java.lang.Object)CorbaConduit.this.orb);
            inMessage.setExchange(exchange);
            CorbaMessage inCorbaMsg = new CorbaMessage((Message)inMessage);
            inCorbaMsg.setCorbaTypeMap(CorbaConduit.this.typeMap);
            if (corbaMsg.getStreamableException() != null) {
                exchange.setInFaultMessage((Message)corbaMsg);
                inCorbaMsg.setStreamableException(corbaMsg.getStreamableException());
                inCorbaMsg.setContent(Exception.class, corbaMsg.getContent(Exception.class));
            } else if (corbaMsg.getSystemException() != null) {
                exchange.setInFaultMessage((Message)corbaMsg);
                inCorbaMsg.setSystemException(corbaMsg.getSystemException());
                inCorbaMsg.setContent(Exception.class, corbaMsg.getContent(Exception.class));
            }
            LOG.log(Level.FINE, "incoming observer is " + CorbaConduit.this.incomingObserver);
            CorbaConduit.this.incomingObserver.onMessage((Message)inCorbaMsg);
            this.message.setContent(Exception.class, inCorbaMsg.getContent(Exception.class));
        }
    }
}

