/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.JMSTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSTransportBase {
    protected Destination targetDestination;
    protected Destination replyDestination;
    protected JMSSessionFactory sessionFactory;
    protected Bus bus;
    protected EndpointInfo endpointInfo;
    protected String beanNameSuffix;
    private JMSTransport transport;

    public JMSTransportBase(Bus b, EndpointInfo endpoint, boolean isServer, String suffix, JMSTransport transport) {
        this.bus = b;
        this.endpointInfo = endpoint;
        this.beanNameSuffix = suffix;
        this.transport = transport;
    }

    protected void connected(Destination target, Destination reply, JMSSessionFactory factory) {
        this.targetDestination = target;
        this.replyDestination = reply;
        this.sessionFactory = factory;
    }

    protected javax.jms.Message marshal(Object payload, Session session, Destination replyTo, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        if (replyTo != null) {
            message.setJMSReplyTo(replyTo);
        }
        return message;
    }

    protected Object unmarshal(javax.jms.Message message) throws JMSException {
        Object ret = null;
        if (message instanceof TextMessage) {
            ret = ((TextMessage)message).getText();
        } else if (message instanceof BytesMessage) {
            byte[] retBytes = new byte[(int)((BytesMessage)message).getBodyLength()];
            ((BytesMessage)message).readBytes(retBytes);
            ret = retBytes;
        } else {
            ret = (byte[])((ObjectMessage)message).getObject();
        }
        return ret;
    }

    protected JMSMessageHeadersType populateIncomingContext(javax.jms.Message message, Message inMessage, String headerType) throws JMSException {
        JMSMessageHeadersType headers = null;
        headers = (JMSMessageHeadersType)inMessage.get((Object)headerType);
        if (headers == null) {
            headers = new JMSMessageHeadersType();
            inMessage.put((Object)headerType, (Object)headers);
        }
        headers.setJMSCorrelationID(message.getJMSCorrelationID());
        headers.setJMSDeliveryMode(new Integer(message.getJMSDeliveryMode()));
        headers.setJMSExpiration(new Long(message.getJMSExpiration()));
        headers.setJMSMessageID(message.getJMSMessageID());
        headers.setJMSPriority(new Integer(message.getJMSPriority()));
        headers.setJMSRedelivered(message.getJMSRedelivered());
        headers.setJMSTimeStamp(new Long(message.getJMSTimestamp()));
        headers.setJMSType(message.getJMSType());
        HashMap<String, List<String>> protHeaders = new HashMap<String, List<String>>();
        List<JMSPropertyType> props = headers.getProperty();
        Enumeration enm = message.getPropertyNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String val = message.getStringProperty(name);
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName(name);
            prop.setValue(val);
            props.add(prop);
            protHeaders.put(name, Collections.singletonList(val));
            if (!name.equals("Content-Type") || val == null) continue;
            inMessage.put((Object)"Content-Type", (Object)val);
        }
        inMessage.put((Object)Message.PROTOCOL_HEADERS, protHeaders);
        return headers;
    }

    protected int getJMSDeliveryMode(JMSMessageHeadersType headers) {
        int deliveryMode = 2;
        if (headers != null && headers.isSetJMSDeliveryMode()) {
            deliveryMode = headers.getJMSDeliveryMode();
        }
        return deliveryMode;
    }

    protected int getJMSPriority(JMSMessageHeadersType headers) {
        int priority = 4;
        if (headers != null && headers.isSetJMSPriority()) {
            priority = headers.getJMSPriority();
        }
        return priority;
    }

    protected long getTimeToLive(JMSMessageHeadersType headers) {
        long ttl = -1L;
        if (headers != null && headers.isSetTimeToLive()) {
            ttl = headers.getTimeToLive();
        }
        return ttl;
    }

    protected String getCorrelationId(JMSMessageHeadersType headers) {
        String correlationId = null;
        if (headers != null && headers.isSetJMSCorrelationID()) {
            correlationId = headers.getJMSCorrelationID();
        }
        return correlationId;
    }

    protected void addProtocolHeaders(javax.jms.Message message, Map<String, List<String>> headers) throws JMSException {
        if (headers == null) {
            return;
        }
        StringBuilder value = new StringBuilder(256);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            value.setLength(0);
            boolean first = true;
            for (String s : entry.getValue()) {
                if (!first) {
                    value.append("; ");
                }
                value.append(s);
                first = false;
            }
            message.setStringProperty(entry.getKey(), value.toString());
        }
    }

    protected void setMessageProperties(JMSMessageHeadersType headers, javax.jms.Message message) throws JMSException {
        if (headers != null && headers.isSetProperty()) {
            List<JMSPropertyType> props = headers.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                message.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    protected boolean isDestinationStyleQueue() {
        return "queue".equals(this.transport.getJMSAddress().getDestinationStyle().value());
    }

    protected void setContentToProtocalHeader(Message message) {
        String contentType = (String)message.get((Object)"Content-Type");
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        if (headers.get("Content-Type") == null) {
            ArrayList<String> ct = new ArrayList<String>();
            ct.add(contentType);
            headers.put("Content-Type", ct);
        } else {
            List<String> ct = headers.get("Content-Type");
            ct.add(contentType);
        }
    }

    protected Map<String, List<String>> getSetProtocolHeaders(Message message) {
        HashMap headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (null == headers) {
            headers = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, headers);
        }
        return headers;
    }
}

