/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container.classloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirewallClassLoader
extends ClassLoader {
    private static final Logger LOG = LogUtils.getL7dLogger(FirewallClassLoader.class);
    private final Map filterTree;

    public FirewallClassLoader(ClassLoader parent, Map filters) {
        super(parent);
        this.filterTree = filters;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        List<String> tokens = this.tokenizeName(name, ".");
        Map map = this.filterTree;
        for (int i = 0; i < tokens.size() - 1 && (map = (Map)map.get(tokens.get(i))) != null; ++i) {
        }
        if (map == null || map.get(tokens.get(tokens.size() - 1) + ".class") == null) {
            return super.loadClass(name, resolve);
        }
        LOG.fine("FirewallClassloader blocking lookup of Class: " + name);
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        List<String> tokens = this.tokenizeName(name, "/");
        Map map = this.filterTree;
        for (int i = 0; i < tokens.size() - 1 && (map = (Map)map.get(tokens.get(i))) != null; ++i) {
        }
        if (map == null || map.get(tokens.get(tokens.size() - 1)) == null) {
            return super.getResource(name);
        }
        LOG.fine("FirewallClassloader blocking lookup of Resource: " + name);
        return null;
    }

    private List<String> tokenizeName(String name, String delimiters) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(name, delimiters);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }
}

