/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.inbound;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.xml.namespace.QName;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jca.inbound.DispatchMDBActivationSpec;
import org.apache.cxf.jca.inbound.DispatchMDBInvoker;
import org.apache.cxf.jca.inbound.InboundEndpoint;
import org.apache.cxf.jca.inbound.MDBActivationSpec;
import org.apache.cxf.jca.inbound.MDBInvoker;
import org.apache.cxf.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDBActivationWork
implements Work {
    private static final Logger LOG = LogUtils.getL7dLogger(MDBActivationWork.class);
    private static final int MAX_ATTEMPTS = 5;
    private static final long RETRY_SLEEP = 5000L;
    private MDBActivationSpec spec;
    private MessageEndpointFactory endpointFactory;
    private boolean released;
    private Map<String, InboundEndpoint> endpoints;

    public MDBActivationWork(MDBActivationSpec spec, MessageEndpointFactory endpointFactory, Map<String, InboundEndpoint> endpoints) {
        this.spec = spec;
        this.endpointFactory = endpointFactory;
        this.endpoints = endpoints;
    }

    public void release() {
        this.released = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageEndpoint endpoint = this.getMesssageEndpoint();
        if (endpoint == null) {
            return;
        }
        ClassLoader classLoader = endpoint.getClass().getClassLoader();
        ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.activate(endpoint, classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassLoader);
        }
    }

    private void activate(MessageEndpoint endpoint, ClassLoader classLoader) {
        Class<?> serviceClass = null;
        if (this.spec.getServiceInterfaceClass() != null) {
            try {
                serviceClass = Class.forName(this.spec.getServiceInterfaceClass(), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.severe("Failed to activate service endpoint " + this.spec.getDisplayName() + " due to unable to endpoint listener.");
                return;
            }
        }
        Object factory = null;
        factory = serviceClass != null && EndpointUtils.hasWebServiceAnnotation(serviceClass) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        if (serviceClass != null) {
            factory.setServiceClass(serviceClass);
        }
        if (this.spec.getWsdlLocation() != null) {
            factory.setWsdlLocation(this.spec.getWsdlLocation());
        }
        if (this.spec.getAddress() != null) {
            factory.setAddress(this.spec.getAddress());
        }
        if (this.spec.getBusConfigLocation() != null) {
            factory.setBus(new SpringBusFactory().createBus(classLoader.getResource(this.spec.getBusConfigLocation())));
        }
        if (this.spec.getEndpointName() != null) {
            factory.setEndpointName(QName.valueOf(this.spec.getEndpointName()));
        }
        if (this.spec.getSchemaLocations() != null) {
            factory.setSchemaLocations(this.getListOfString(this.spec.getSchemaLocations()));
        }
        if (this.spec.getServiceName() != null) {
            factory.setServiceName(QName.valueOf(this.spec.getServiceName()));
        }
        MDBInvoker invoker = this.createInvoker(endpoint);
        factory.setInvoker((Invoker)invoker);
        factory.setStart(true);
        Server server = factory.create();
        this.endpoints.put(this.spec.getDisplayName(), new InboundEndpoint(server, invoker));
    }

    private List<String> getListOfString(String str) {
        if (str == null) {
            return null;
        }
        return Arrays.asList(str.split(","));
    }

    private MDBInvoker createInvoker(MessageEndpoint endpoint) {
        MDBInvoker answer = null;
        answer = this.spec instanceof DispatchMDBActivationSpec ? new DispatchMDBInvoker(endpoint, ((DispatchMDBActivationSpec)this.spec).getTargetBeanJndiName()) : new MDBInvoker(endpoint);
        return answer;
    }

    private MessageEndpoint getMesssageEndpoint() {
        MessageEndpoint answer = null;
        for (int i = 0; i < 5; ++i) {
            if (this.released) {
                LOG.warning("CXF service activation has been stopped.");
                return null;
            }
            try {
                answer = this.endpointFactory.createEndpoint(null);
                break;
            }
            catch (UnavailableException e) {
                LOG.fine("Target endpoint activation in progress.  Will retry.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        if (answer == null) {
            LOG.severe("Failed to activate  service endpoint " + this.spec.getDisplayName() + " due to unable to endpoint listener.");
        }
        return answer;
    }
}

