/*
 * Decompiled with CFR 0.152.
 */
package com.iona.cxf.container;

import com.iona.cxf.container.ApplicationState;
import com.iona.cxf.container.ContainerException;
import com.iona.cxf.container.classloader.ApplicationClassLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

class ApplicationContext {
    private static final Logger LOG = LogUtils.getL7dLogger(ApplicationContext.class);
    private static final String SPRING_CONFIG_DIR = "META-INF/spring";
    private static final String XML_FILE_SUFFIX = ".xml";
    private GenericApplicationContext context;
    private File appDir;
    private ClassLoader loader;
    private ApplicationState state;

    public ApplicationContext(File dir) throws ContainerException {
        this.appDir = dir;
        this.state = ApplicationState.STOPPED;
    }

    public File getApplicationDirectory() {
        return this.appDir;
    }

    public synchronized void start() throws ContainerException {
        this.changeState(Event.START);
    }

    public synchronized void stop() throws ContainerException {
        this.changeState(Event.STOP);
    }

    public ApplicationState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(Event event) throws ContainerException {
        switch (event) {
            case STOP: {
                if (this.state != ApplicationState.STARTED) break;
                try {
                    this.cleanup();
                    break;
                }
                finally {
                    this.state = ApplicationState.STOPPED;
                }
            }
            case START: {
                if (this.state != ApplicationState.STOPPED && this.state != ApplicationState.FAILED) break;
                try {
                    this.init();
                    this.state = ApplicationState.STARTED;
                    break;
                }
                catch (ContainerException cex) {
                    this.state = ApplicationState.FAILED;
                    this.cleanup();
                    throw cex;
                }
            }
        }
    }

    private void init() throws ContainerException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            this.loader = ApplicationClassLoader.createClassLoader(this.appDir);
            Thread.currentThread().setContextClassLoader(this.loader);
            this.context = new GenericApplicationContext();
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context);
            reader.setBeanClassLoader(this.loader);
            File springConfDir = new File(this.appDir, SPRING_CONFIG_DIR);
            File[] files = springConfDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(ApplicationContext.XML_FILE_SUFFIX);
                }
            });
            if (null != files) {
                for (File file : files) {
                    FileSystemResource resource = new FileSystemResource(file);
                    reader.loadBeanDefinitions((Resource)resource);
                }
            } else {
                throw new ContainerException(new Message("MISSING_SPRING_BEAN_DEFINITIONS", LOG, new Object[0]));
            }
            this.context.refresh();
        }
        catch (Exception ex) {
            throw new ContainerException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.loader);
            this.context.close();
        }
        finally {
            this.context = null;
            this.loader = null;
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Event {
        START,
        STOP;

    }
}

