/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolicyInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected Bus bus;

    public AbstractPolicyInterceptor(String phase) {
        super(phase);
    }

    public AbstractPolicyInterceptor(String id, String phase) {
        super(id, phase);
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        try {
            this.handle(message);
        }
        catch (PolicyException ex) {
            throw new Fault(ex);
        }
    }

    protected void getTransportAssertions(Message message) {
        Exchange ex = message.getExchange();
        Assertor assertor = null;
        Conduit conduit = ex.getConduit(message);
        if (conduit instanceof Assertor) {
            assertor = (Assertor)((Object)conduit);
        } else {
            Destination destination = ex.getDestination();
            if (destination instanceof Assertor) {
                assertor = (Assertor)((Object)destination);
            }
        }
        if (null != assertor) {
            assertor.assertMessage(message);
        }
    }

    protected BindingFaultInfo getBindingFaultInfo(Message msg, Exception ex, BindingOperationInfo boi) {
        BindingFaultInfo bfi = msg.get(BindingFaultInfo.class);
        if (null == bfi) {
            Class faultClass;
            Throwable cause = ex.getCause();
            if (null == cause) {
                return null;
            }
            for (BindingFaultInfo b : boi.getFaults()) {
                faultClass = b.getFaultInfo().getProperty(Class.class.getName(), Class.class);
                if (!faultClass.isAssignableFrom(cause.getClass())) continue;
                bfi = b;
                msg.put(BindingFaultInfo.class, bfi);
                break;
            }
            if (null == bfi && null != boi.getWrappedOperation()) {
                for (BindingFaultInfo b : boi.getWrappedOperation().getFaults()) {
                    faultClass = b.getFaultInfo().getProperty(Class.class.getName(), Class.class);
                    if (!faultClass.isAssignableFrom(cause.getClass())) continue;
                    bfi = b;
                    msg.put(BindingFaultInfo.class, bfi);
                    break;
                }
            }
        }
        return bfi;
    }

    protected abstract void handle(Message var1) throws PolicyException;
}

