/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedMessageContext
implements MessageContext {
    public static final String SCOPES = WrappedMessageContext.class.getName() + ".SCOPES";
    private static Map<String, String> cxf2jaxwsMap = new HashMap<String, String>();
    private static Map<String, String> jaxws2cxfMap = new HashMap<String, String>();
    private final Map<String, Object> message;
    private final Map<String, Object> reqMessage;
    private final Exchange exchange;
    private Map<String, MessageContext.Scope> scopes;
    private MessageContext.Scope defaultScope;

    public WrappedMessageContext(Message m) {
        this(m, MessageContext.Scope.HANDLER);
    }

    public WrappedMessageContext(Message m, MessageContext.Scope defScope) {
        this((Map<String, Object>)m, m.getExchange(), defScope);
    }

    public WrappedMessageContext(Map<String, Object> m, Exchange ex, MessageContext.Scope defScope) {
        this.message = m;
        this.exchange = ex;
        this.defaultScope = defScope;
        this.scopes = CastUtils.cast((Map)((Map)this.message.get(SCOPES)));
        this.reqMessage = this.isResponse() && this.exchange != null ? (this.isRequestor() ? this.exchange.getOutMessage() : this.exchange.getInMessage()) : null;
        if (this.scopes == null && this.reqMessage != null) {
            this.scopes = CastUtils.cast((Map)((Map)this.reqMessage.get(SCOPES)));
            if (this.scopes != null) {
                m.put(SCOPES, this.scopes);
                this.copyScoped(this.reqMessage);
            }
        }
        if (this.scopes == null) {
            this.scopes = new HashMap<String, MessageContext.Scope>();
            this.message.put(SCOPES, this.scopes);
        }
    }

    private void copyScoped(Map<String, Object> msg) {
        for (String s : this.scopes.keySet()) {
            this.message.put(s, msg.get(s));
        }
    }

    private String mapKey(String key) {
        String k2 = jaxws2cxfMap.get(key);
        if (k2 != null) {
            return k2;
        }
        return key;
    }

    private String mapKeyReverse(String key) {
        String k2 = cxf2jaxwsMap.get(key);
        if (k2 != null) {
            return k2;
        }
        if (Message.PROTOCOL_HEADERS.equals(key)) {
            return this.isResponse() ? "javax.xml.ws.http.response.headers" : "javax.xml.ws.http.request.headers";
        }
        return key;
    }

    protected final boolean isResponse() {
        return this.isOutbound() ^ this.isRequestor();
    }

    protected final boolean isRequestor() {
        return Boolean.TRUE.equals(this.message.containsKey("org.apache.cxf.client"));
    }

    protected final boolean isOutbound() {
        return this.message != null && this.exchange != null && (this.message == this.exchange.getOutMessage() || this.message == this.exchange.getOutFaultMessage());
    }

    public final Message getWrappedMessage() {
        return this.message instanceof Message ? (Message)this.message : null;
    }

    public void clear() {
        for (String key : jaxws2cxfMap.keySet()) {
            this.remove(key);
        }
    }

    public final boolean containsKey(Object key) {
        return this.message.containsKey(this.mapKey((String)key));
    }

    public final boolean containsValue(Object value) {
        return this.message.containsValue(value);
    }

    public Object get(Object key) {
        String mappedkey = this.mapKey((String)key);
        Object ret = this.message.get(mappedkey);
        if (ret == null) {
            AuthorizationPolicy authPolicy;
            if (Message.class.getName().equals(mappedkey)) {
                return this.message;
            }
            if (this.exchange != null && (ret = this.exchange.get((Object)mappedkey)) != null) {
                return ret;
            }
            if ("javax.xml.ws.binding.attachments.inbound".equals(key)) {
                if (this.isOutbound()) {
                    ret = this.reqMessage.get(key);
                }
                ret = this.createAttachments(this.getWrappedMessage(), "javax.xml.ws.binding.attachments.inbound");
            } else if ("javax.xml.ws.binding.attachments.outbound".equals(key)) {
                ret = this.createAttachments(this.isRequestor() ? this.getWrappedMessage() : this.createResponseMessage(), "javax.xml.ws.binding.attachments.outbound");
            } else if ("javax.xml.ws.handler.message.outbound".equals(key)) {
                ret = this.isOutbound();
            } else if ("javax.xml.ws.http.request.headers".equals(key)) {
                if (!this.isResponse()) {
                    ret = this.message.get(Message.PROTOCOL_HEADERS);
                } else if (this.reqMessage != null && !this.isRequestor()) {
                    ret = this.reqMessage.get(Message.PROTOCOL_HEADERS);
                }
            } else if ("javax.xml.ws.http.response.headers".equals(key)) {
                Message tmp;
                Map mp = null;
                if (this.isResponse()) {
                    mp = (Map)this.message.get(Message.PROTOCOL_HEADERS);
                } else if (this.exchange != null && (tmp = this.createResponseMessage()) != null) {
                    ret = (Map)tmp.get((Object)Message.PROTOCOL_HEADERS);
                }
                ret = mp;
            } else if ("javax.xml.ws.security.auth.username".equals(key)) {
                AuthorizationPolicy authPolicy2 = (AuthorizationPolicy)this.message.get(AuthorizationPolicy.class.getName());
                if (authPolicy2 != null) {
                    ret = authPolicy2.getUserName();
                }
            } else if ("javax.xml.ws.security.auth.password".equals(key) && (authPolicy = (AuthorizationPolicy)this.message.get(AuthorizationPolicy.class.getName())) != null) {
                ret = authPolicy.getPassword();
            }
            if (ret == null && this.reqMessage != null) {
                ret = this.reqMessage.get(mappedkey);
            }
        }
        return ret;
    }

    private Message createResponseMessage() {
        if (this.exchange == null || this.exchange.isOneWay()) {
            return null;
        }
        if (this.isResponse()) {
            return this.getWrappedMessage();
        }
        Message m = null;
        if (this.isRequestor()) {
            m = this.exchange.getInFaultMessage();
            if (m == null) {
                m = this.exchange.getInMessage();
            }
            if (m == null) {
                Endpoint ep = (Endpoint)this.exchange.get(Endpoint.class);
                m = ep.getBinding().createMessage();
                this.exchange.setInMessage(m);
            }
        } else {
            m = this.exchange.getOutMessage();
            if (m == null) {
                m = this.exchange.getOutFaultMessage();
            }
            if (m == null) {
                Endpoint ep = (Endpoint)this.exchange.get(Endpoint.class);
                m = ep.getBinding().createMessage();
                this.exchange.setOutMessage(m);
            }
        }
        return m;
    }

    private Object createAttachments(Message mc, String propertyName) {
        if (mc == null) {
            return null;
        }
        Collection attachments = mc.getAttachments();
        Map<String, DataHandler> dataHandlers = WrappedMessageContext.getDHMap(attachments);
        mc.put((Object)propertyName, dataHandlers);
        this.scopes.put(propertyName, MessageContext.Scope.APPLICATION);
        return dataHandlers;
    }

    private static Map<String, DataHandler> getDHMap(Collection<Attachment> attachments) {
        Map<String, DataHandler> dataHandlers = null;
        if (attachments != null) {
            if (attachments instanceof LazyAttachmentCollection) {
                dataHandlers = ((LazyAttachmentCollection)attachments).createDataHandlerMap();
            } else {
                dataHandlers = new LinkedHashMap();
                for (Attachment attachment : attachments) {
                    dataHandlers.put(attachment.getId(), attachment.getDataHandler());
                }
            }
        }
        return dataHandlers == null ? new LinkedHashMap() : dataHandlers;
    }

    public final boolean isEmpty() {
        return this.message.isEmpty();
    }

    public final Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (String s : this.message.keySet()) {
            set.add(s);
            set.add(this.mapKeyReverse(s));
        }
        return Collections.unmodifiableSet(set);
    }

    public final Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> s : this.message.entrySet()) {
            set.add(s);
            final String s2 = this.mapKeyReverse(s.getKey());
            final Object o = s.getValue();
            if (!s2.equals(s.getKey())) continue;
            Map.Entry<String, Object> entry = new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return s2;
                }

                @Override
                public Object getValue() {
                    return o;
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
            set.add(entry);
        }
        return Collections.unmodifiableSet(set);
    }

    public final Object put(String key, Object value) {
        return this.put(key, value, this.defaultScope);
    }

    public final Object put(String key, Object value, MessageContext.Scope scope) {
        String mappedKey = this.mapKey(key);
        if (!"javax.xml.ws.handler.message.outbound".equals(mappedKey)) {
            this.scopes.put(mappedKey, scope);
        }
        if (("javax.xml.ws.http.response.headers".equals(key) || "javax.xml.ws.http.response.code".equals(key) || "javax.xml.ws.binding.attachments.outbound".equals(key) || "javax.xml.ws.http.response.code".equals(key)) && !this.isResponse() && !this.isRequestor()) {
            Message tmp = this.createResponseMessage();
            if (tmp != null) {
                if ("javax.xml.ws.http.response.headers".equals(key)) {
                    return tmp.put((Object)Message.PROTOCOL_HEADERS, value);
                }
                return tmp.put((Object)mappedKey, value);
            }
            return null;
        }
        if ("javax.xml.ws.security.auth.username".equals(key)) {
            AuthorizationPolicy authPolicy = (AuthorizationPolicy)this.message.get(AuthorizationPolicy.class.getName());
            if (authPolicy == null) {
                authPolicy = new AuthorizationPolicy();
                this.message.put(AuthorizationPolicy.class.getName(), authPolicy);
            }
            String ret = authPolicy.getUserName();
            authPolicy.setUserName((String)value);
            return ret;
        }
        if ("javax.xml.ws.security.auth.password".equals(key)) {
            AuthorizationPolicy authPolicy = (AuthorizationPolicy)this.message.get(AuthorizationPolicy.class.getName());
            if (authPolicy == null) {
                authPolicy = new AuthorizationPolicy();
                this.message.put(AuthorizationPolicy.class.getName(), authPolicy);
            }
            String ret = authPolicy.getPassword();
            authPolicy.setPassword((String)value);
            return ret;
        }
        return this.message.put(mappedKey, value);
    }

    public final void putAll(Map<? extends String, ? extends Object> t) {
        for (Map.Entry<? extends String, ? extends Object> s : t.entrySet()) {
            this.put(s.getKey(), s.getValue());
        }
    }

    public final Object remove(Object key) {
        key = this.mapKey((String)key);
        this.scopes.remove(key);
        return this.message.remove(key);
    }

    public final int size() {
        return this.message.size();
    }

    public final Collection<Object> values() {
        return this.message.values();
    }

    public final void setScope(String key, MessageContext.Scope arg1) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("non-existant property-" + key + "is specified");
        }
        this.scopes.put(key, arg1);
    }

    public final MessageContext.Scope getScope(String key) {
        if (this.containsKey(key)) {
            if (this.scopes.containsKey(key)) {
                return this.scopes.get(key);
            }
            return this.defaultScope;
        }
        throw new IllegalArgumentException("non-existant property-" + key + "is specified");
    }

    public final Map<String, MessageContext.Scope> getScopes() {
        return this.scopes;
    }

    static {
        cxf2jaxwsMap.put(Message.ENDPOINT_ADDRESS, "javax.xml.ws.service.endpoint.address");
        cxf2jaxwsMap.put(Message.MAINTAIN_SESSION, "javax.xml.ws.session.maintain");
        cxf2jaxwsMap.put(Message.HTTP_REQUEST_METHOD, "javax.xml.ws.http.request.method");
        cxf2jaxwsMap.put(Message.RESPONSE_CODE, "javax.xml.ws.http.response.code");
        cxf2jaxwsMap.put(Message.PATH_INFO, "javax.xml.ws.http.request.pathinfo");
        cxf2jaxwsMap.put(Message.QUERY_STRING, "javax.xml.ws.http.request.querystring");
        cxf2jaxwsMap.put("HTTP.REQUEST", "javax.xml.ws.servlet.request");
        cxf2jaxwsMap.put("HTTP.RESPONSE", "javax.xml.ws.servlet.response");
        cxf2jaxwsMap.put("HTTP.CONTEXT", "javax.xml.ws.servlet.context");
        jaxws2cxfMap.put("javax.xml.ws.service.endpoint.address", Message.ENDPOINT_ADDRESS);
        jaxws2cxfMap.put("javax.xml.ws.session.maintain", Message.MAINTAIN_SESSION);
        jaxws2cxfMap.put("javax.xml.ws.http.request.method", Message.HTTP_REQUEST_METHOD);
        jaxws2cxfMap.put("javax.xml.ws.http.response.code", Message.RESPONSE_CODE);
        jaxws2cxfMap.put("javax.xml.ws.http.request.pathinfo", Message.PATH_INFO);
        jaxws2cxfMap.put("javax.xml.ws.http.request.querystring", Message.QUERY_STRING);
        jaxws2cxfMap.put("javax.xml.ws.servlet.request", "HTTP.REQUEST");
        jaxws2cxfMap.put("javax.xml.ws.servlet.response", "HTTP.RESPONSE");
        jaxws2cxfMap.put("javax.xml.ws.servlet.context", "HTTP.CONTEXT");
        jaxws2cxfMap.put("javax.xml.ws.soap.http.soapaction.uri", "SOAPAction");
    }
}

