/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DestinationResolver;

public class JMSDestination
extends AbstractMultiplexDestination
implements MessageListener,
JMSExchangeSender {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    private JMSConfiguration jmsConfig;
    private Bus bus;
    private DefaultMessageListenerContainer jmsListener;

    public JMSDestination(Bus b, EndpointInfo info, JMSConfiguration jmsConfig) {
        super(b, JMSDestination.getTargetReference((EndpointInfo)info, (Bus)b), info);
        this.bus = b;
        this.jmsConfig = jmsConfig;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        EndpointReferenceType anon = EndpointReferenceUtils.getAnonymousEndpointReference();
        return new BackChannelConduit(this, anon, inMessage);
    }

    public void activate() {
        this.getLogger().log(Level.INFO, "JMSDestination activate().... ");
        String name = this.endpointInfo.getName().toString() + ".jms-destination";
        if (this.jmsConfig.getTargetDestination() == null || this.jmsConfig.getConnectionFactory() == null) {
            throw new RuntimeException("Insufficient configuration for Destination. Did you configure a <jms:destination name=\"" + name + "\"> and set the jndiConnectionFactoryName ?");
        }
        this.jmsListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getTargetDestination());
        this.jmsConfig.getTargetDestination();
    }

    public void deactivate() {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
    }

    public void shutdown() {
        this.getLogger().log(Level.FINE, "JMSDestination shutdown()");
        this.deactivate();
    }

    private javax.jms.Destination resolveDestinationName(final JmsTemplate jmsTemplate, final String name) {
        return (javax.jms.Destination)jmsTemplate.execute(new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                DestinationResolver resolv = jmsTemplate.getDestinationResolver();
                return resolv.resolveDestinationName(session, name, JMSDestination.this.jmsConfig.isPubSubDomain());
            }
        });
    }

    public javax.jms.Destination getReplyToDestination(JmsTemplate jmsTemplate, Message inMessage) throws JMSException {
        javax.jms.Message message = (javax.jms.Message)inMessage.get((Object)"org.apache.cxf.jms.request.message");
        String replyToName = (String)inMessage.get((Object)"org.apache.cxf.jms.server.replyto");
        if (replyToName != null) {
            return this.resolveDestinationName(jmsTemplate, replyToName);
        }
        if (message.getJMSReplyTo() != null) {
            return message.getJMSReplyTo();
        }
        throw new RuntimeException("No replyTo destination set on request message or cxf message");
    }

    public String determineCorrelationID(javax.jms.Message request) throws JMSException {
        String correlationID = request.getJMSCorrelationID();
        if (correlationID == null || "".equals(correlationID)) {
            correlationID = request.getJMSMessageID();
        }
        return correlationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message message) {
        try {
            this.getLogger().log(Level.FINE, "server received request: ", message);
            byte[] request = JMSUtils.retrievePayload(message);
            this.getLogger().log(Level.FINE, "The Request Message is [ " + request + "]");
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(request));
            JMSUtils.populateIncomingContext(message, (Message)inMessage, "org.apache.cxf.jms.server.request.headers");
            inMessage.put((Object)"org.apache.cxf.jms.server.response.headers", (Object)new JMSMessageHeadersType());
            inMessage.put((Object)"org.apache.cxf.jms.request.message", (Object)message);
            inMessage.setDestination((Destination)this);
            BusFactory.setThreadDefaultBus((Bus)this.bus);
            this.incomingObserver.onMessage((Message)inMessage);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public void sendExchange(Exchange exchange, final Object replyObj) {
        Message inMessage = exchange.getInMessage();
        final Message outMessage = exchange.getOutMessage();
        if (this.jmsConfig.isPubSubDomain()) {
            this.getLogger().log(Level.WARNING, "discarding reply for non-oneway invocation ", "with 'topic' destinationStyle");
            return;
        }
        try {
            final JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.server.response.headers");
            JMSMessageHeadersType inHeaders = (JMSMessageHeadersType)inMessage.get((Object)"org.apache.cxf.jms.server.request.headers");
            JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, inHeaders);
            final javax.jms.Message request = (javax.jms.Message)inMessage.get((Object)"org.apache.cxf.jms.request.message");
            final String msgType = request instanceof TextMessage ? "text" : (request instanceof BytesMessage ? "byte" : "binary");
            javax.jms.Destination replyTo = this.getReplyToDestination(jmsTemplate, inMessage);
            if (request.getJMSExpiration() > 0L) {
                SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
                GregorianCalendar cal = new GregorianCalendar(tz);
                long timeToLive = request.getJMSExpiration() - cal.getTimeInMillis();
                if (timeToLive < 0L) {
                    this.getLogger().log(Level.INFO, "Message time to live is already expired skipping response.");
                    return;
                }
            }
            this.getLogger().log(Level.FINE, "send out the message!");
            jmsTemplate.send(replyTo, new MessageCreator(){

                public javax.jms.Message createMessage(Session session) throws JMSException {
                    javax.jms.Message reply = JMSUtils.createAndSetPayload(replyObj, session, msgType);
                    reply.setJMSCorrelationID(JMSDestination.this.determineCorrelationID(request));
                    JMSUtils.setMessageProperties(headers, reply);
                    JMSUtils.addContentTypeToProtocolHeader(outMessage);
                    Map protHeaders = CastUtils.cast((Map)((Map)outMessage.get((Object)Message.PROTOCOL_HEADERS)));
                    JMSUtils.addProtocolHeaders(reply, protHeaders);
                    LOG.log(Level.FINE, "server sending reply: ", reply);
                    return reply;
                }
            });
        }
        catch (JMSException ex) {
            JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        private JMSExchangeSender sender;

        BackChannelConduit(JMSExchangeSender sender, EndpointReferenceType ref, Message message) {
            super(ref);
            this.inMessage = message;
            this.sender = sender;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            javax.jms.Message jmsMessage = (javax.jms.Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
            message.put((Object)"org.apache.cxf.jms.request.message", (Object)jmsMessage);
            if (!message.containsKey((Object)"org.apache.cxf.jms.server.response.headers") && this.inMessage.containsKey((Object)"org.apache.cxf.jms.server.response.headers")) {
                message.put((Object)"org.apache.cxf.jms.server.response.headers", this.inMessage.get((Object)"org.apache.cxf.jms.server.response.headers"));
            }
            Exchange exchange = this.inMessage.getExchange();
            exchange.setOutMessage(message);
            message.setContent(OutputStream.class, (Object)new JMSOutputStream(this.sender, exchange, jmsMessage instanceof TextMessage));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

