/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty.spring;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.spring.TLSServerParametersConfig;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.http_jetty.spring.JAXBHelper;
import org.apache.cxf.transports.http_jetty.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_jetty.configuration.ThreadingParametersType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHTTPServerEngineFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String HTTP_JETTY_NS = "http://cxf.apache.org/transports/http-jetty/configuration";

    public void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        String bus = element.getAttribute("bus");
        try {
            List<ThreadingParametersIdentifiedType> threadingParametersIdentifiedTypes = JAXBHelper.parseListElement(element, bean, new QName(HTTP_JETTY_NS, "identifiedThreadingParameters"), ThreadingParametersIdentifiedType.class);
            Map<String, ThreadingParameters> threadingParametersMap = this.toThreadingParameters(threadingParametersIdentifiedTypes);
            List<TLSServerParametersIdentifiedType> tlsServerParameters = JAXBHelper.parseListElement(element, bean, new QName(HTTP_JETTY_NS, "identifiedTLSServerParameters"), TLSServerParametersIdentifiedType.class);
            Map<String, TLSServerParameters> tlsServerParametersMap = this.toTLSServerParamenters(tlsServerParameters);
            bean.addPropertyValue("threadingParametersMap", threadingParametersMap);
            bean.addPropertyValue("tlsServerParametersMap", tlsServerParametersMap);
            if (StringUtils.isEmpty((String)bus)) {
                this.addBusWiringAttribute(bean, BusWiringType.PROPERTY);
            } else {
                bean.addPropertyReference("bus", bus);
            }
            List list = this.getRequiredElementsList(element, ctx, new QName(HTTP_JETTY_NS, "engine"), bean);
            if (list.size() > 0) {
                bean.addPropertyValue("enginesList", (Object)list);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    private List getRequiredElementsList(Element parent, ParserContext ctx, QName name, BeanDefinitionBuilder bean) {
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)parent, (String)name.getNamespaceURI(), (String)name.getLocalPart());
        ManagedList list = new ManagedList(elemList.size());
        list.setSource(ctx.extractSource((Object)parent));
        for (Element elem : elemList) {
            list.add(ctx.getDelegate().parsePropertySubElement(elem, (BeanDefinition)bean.getBeanDefinition()));
        }
        return list;
    }

    private Map<String, ThreadingParameters> toThreadingParameters(List<ThreadingParametersIdentifiedType> list) {
        TreeMap<String, ThreadingParameters> map = new TreeMap<String, ThreadingParameters>();
        for (ThreadingParametersIdentifiedType t : list) {
            ThreadingParameters parameter = this.toThreadingParameters(t.getThreadingParameters());
            map.put(t.getId(), parameter);
        }
        return map;
    }

    private ThreadingParameters toThreadingParameters(ThreadingParametersType paramtype) {
        ThreadingParameters params = new ThreadingParameters();
        params.setMaxThreads(paramtype.getMaxThreads());
        params.setMinThreads(paramtype.getMinThreads());
        return params;
    }

    private Map<String, TLSServerParameters> toTLSServerParamenters(List<TLSServerParametersIdentifiedType> list) {
        TreeMap<String, TLSServerParameters> map = new TreeMap<String, TLSServerParameters>();
        for (TLSServerParametersIdentifiedType t : list) {
            try {
                TLSServerParametersConfig parameter = new TLSServerParametersConfig(t.getTlsServerParameters());
                map.put(t.getId(), (TLSServerParameters)parameter);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not configure TLS for id " + t.getId(), e);
            }
        }
        return map;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class getBeanClass(Element arg0) {
        return SpringJettyHTTPServerEngineFactory.class;
    }

    public static class SpringJettyHTTPServerEngineFactory
    extends JettyHTTPServerEngineFactory
    implements ApplicationContextAware {
        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            if (this.getBus() == null) {
                Bus bus = BusFactory.getThreadDefaultBus();
                BusWiringBeanFactoryPostProcessor.updateBusReferencesInContext((Bus)bus, (ApplicationContext)ctx);
                this.setBus(bus);
                this.registerWithBus();
            }
        }
    }
}

