/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWorkers;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MessageBodyWorkersImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoComparator;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXRSUtils {
    public static final MediaType ALL_TYPES = new MediaType();
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSUtils.class);

    private JAXRSUtils() {
    }

    public static List<PathSegment> getPathSegments(String thePath, boolean decode) {
        String[] segments = thePath.split("/");
        ArrayList<PathSegment> theList = new ArrayList<PathSegment>();
        for (String path : segments) {
            if (StringUtils.isEmpty((String)path)) continue;
            theList.add(new PathSegmentImpl(path, decode));
        }
        return theList;
    }

    public static List<MediaType> getMediaTypes(String[] values) {
        ArrayList<MediaType> supportedMimeTypes = new ArrayList<MediaType>(values.length);
        for (int i = 0; i < values.length; ++i) {
            supportedMimeTypes.add(MediaType.valueOf((String)values[i]));
        }
        return supportedMimeTypes;
    }

    public static ClassResourceInfo findSubResourceClass(ClassResourceInfo resource, Class subResourceClassType) {
        for (ClassResourceInfo subCri : resource.getSubClassResourceInfo()) {
            if (!subCri.getResourceClass().isAssignableFrom(subResourceClassType)) continue;
            return subCri;
        }
        return null;
    }

    public static void handleSetters(OperationResourceInfo ori, Object requestObject, Message message) {
        Object o;
        ClassResourceInfo cri = ori.getClassResourceInfo();
        InjectionUtils.injectContextMethods(requestObject, cri, message);
        String relativePath = (String)message.get((Object)"relative.path");
        MultivaluedMap values = (MultivaluedMap)message.get((Object)"jaxrs.template.parameters");
        for (Method m : cri.getParameterMethods()) {
            o = JAXRSUtils.createHttpParameterValue(m.getAnnotations(), m.getParameterTypes()[0], m.getGenericParameterTypes()[0], message, (MultivaluedMap<String, String>)values, relativePath, ori);
            if (o == null) continue;
            InjectionUtils.injectThroughMethod(requestObject, m, o);
        }
        for (Field f : cri.getParameterFields()) {
            o = JAXRSUtils.createHttpParameterValue(f.getAnnotations(), f.getType(), f.getGenericType(), message, (MultivaluedMap<String, String>)values, relativePath, ori);
            if (o == null) continue;
            InjectionUtils.injectFieldValue(f, requestObject, o);
        }
    }

    public static ClassResourceInfo selectResourceClass(List<ClassResourceInfo> resources, String path, MultivaluedMap<String, String> values) {
        if (resources.size() == 1) {
            return resources.get(0).getURITemplate().match(path, values) ? resources.get(0) : null;
        }
        TreeMap<ClassResourceInfo, MetadataMap<String, String>> candidateList = new TreeMap<ClassResourceInfo, MetadataMap<String, String>>(new Comparator<ClassResourceInfo>(){

            @Override
            public int compare(ClassResourceInfo cr1, ClassResourceInfo cr2) {
                int g2;
                String l2;
                String l1 = cr1.getURITemplate().getLiteralChars();
                if (!l1.equals(l2 = cr2.getURITemplate().getLiteralChars())) {
                    return l1.length() < l2.length() ? 1 : -1;
                }
                int g1 = cr1.getURITemplate().getNumberOfGroups();
                return g1 < (g2 = cr2.getURITemplate().getNumberOfGroups()) ? 1 : (g1 > g2 ? -1 : 0);
            }
        });
        for (ClassResourceInfo resource : resources) {
            MetadataMap<String, String> map = new MetadataMap<String, String>();
            if (!resource.getURITemplate().match(path, map)) continue;
            candidateList.put(resource, map);
        }
        if (!candidateList.isEmpty()) {
            Map.Entry firstEntry = candidateList.entrySet().iterator().next();
            values.putAll((Map)firstEntry.getValue());
            return (ClassResourceInfo)firstEntry.getKey();
        }
        return null;
    }

    public static OperationResourceInfo findTargetMethod(ClassResourceInfo resource, String path, String httpMethod, MultivaluedMap<String, String> values, String requestContentType, List<MediaType> acceptContentTypes) {
        TreeMap<OperationResourceInfo, MultivaluedMap<String, String>> candidateList = new TreeMap<OperationResourceInfo, MultivaluedMap<String, String>>(new OperationResourceInfoComparator());
        MediaType requestType = requestContentType == null ? ALL_TYPES : MediaType.valueOf((String)requestContentType);
        for (MediaType acceptType : acceptContentTypes) {
            for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
                String finalGroup;
                URITemplate uriTemplate = ori.getURITemplate();
                MultivaluedMap<String, String> map = JAXRSUtils.cloneMap(values);
                if (uriTemplate == null || !uriTemplate.match(path, map)) continue;
                if (ori.isSubResourceLocator()) {
                    candidateList.put(ori, map);
                    continue;
                }
                if (!ori.getHttpMethod().equalsIgnoreCase(httpMethod) || !JAXRSUtils.matchMimeTypes(requestType, acceptType, ori) || (finalGroup = (String)map.getFirst((Object)"FINAL_MATCH_GROUP")) != null && !StringUtils.isEmpty((String)finalGroup) && !finalGroup.equals("/")) continue;
                candidateList.put(ori, map);
            }
            if (candidateList.isEmpty()) continue;
            Map.Entry firstEntry = candidateList.entrySet().iterator().next();
            values.clear();
            values.putAll((Map)firstEntry.getValue());
            return (OperationResourceInfo)firstEntry.getKey();
        }
        return null;
    }

    public static List<MediaType> getConsumeTypes(ConsumeMime cm) {
        return cm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(cm.value());
    }

    public static List<MediaType> getProduceTypes(ProduceMime pm) {
        return pm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(pm.value());
    }

    public static int compareMediaTypes(MediaType mt1, MediaType mt2) {
        if (mt1.equals((Object)mt2)) {
            float q2;
            float q1 = JAXRSUtils.getMediaTypeQualityFactor((String)mt1.getParameters().get("q"));
            int result = Float.compare(q1, q2 = JAXRSUtils.getMediaTypeQualityFactor((String)mt2.getParameters().get("q")));
            return result == 0 ? result : ~result;
        }
        if (mt1.isWildcardType() && !mt2.isWildcardType()) {
            return 1;
        }
        if (!mt1.isWildcardType() && mt2.isWildcardType()) {
            return -1;
        }
        if (mt1.getType().equals(mt2.getType())) {
            if (mt1.isWildcardSubtype() && !mt2.isWildcardSubtype()) {
                return 1;
            }
            if (!mt1.isWildcardSubtype() && mt2.isWildcardSubtype()) {
                return -1;
            }
        }
        return mt1.toString().compareTo(mt2.toString());
    }

    public static float getMediaTypeQualityFactor(String q) {
        if (q == null) {
            return 1.0f;
        }
        if (q.charAt(0) == '.') {
            q = '0' + q;
        }
        try {
            return Float.parseFloat(q);
        }
        catch (NumberFormatException numberFormatException) {
            return 1.0f;
        }
    }

    public static List<Object> processParameters(OperationResourceInfo ori, MultivaluedMap<String, String> values, Message message) {
        Method method = ori.getAnnotatedMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<Object> params = new ArrayList<Object>(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object param = JAXRSUtils.processParameter(parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i], values, message, ori);
            params.add(param);
        }
        return params;
    }

    private static Object processParameter(Class<?> parameterClass, Type parameterType, Annotation[] parameterAnns, MultivaluedMap<String, String> values, Message message, OperationResourceInfo ori) {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        String path = (String)message.get((Object)"relative.path");
        if (parameterAnns == null || !AnnotationUtils.isMethodParamAnnotations(parameterAnns)) {
            String contentType = (String)message.get((Object)"Content-Type");
            if (contentType == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_CONTENT_TYPE_SPECIFIED", LOG, new Object[]{ori.getHttpMethod()}));
            }
            return JAXRSUtils.readFromMessageBody(parameterClass, parameterType, parameterAnns, is, MediaType.valueOf((String)contentType), ori.getConsumeTypes(), message);
        }
        if (parameterAnns[0].annotationType() == Context.class) {
            return JAXRSUtils.createContextValue(message, parameterType, parameterClass);
        }
        return JAXRSUtils.createHttpParameterValue(parameterAnns, parameterClass, parameterType, message, values, path, ori);
    }

    private static Object createHttpParameterValue(Annotation[] anns, Class<?> parameterClass, Type genericParam, Message message, MultivaluedMap<String, String> values, String path, OperationResourceInfo ori) {
        boolean isEncoded = AnnotationUtils.isEncoded(anns, ori);
        String defaultValue = AnnotationUtils.getDefaultParameterValue(anns, ori);
        PathParam pathParam = AnnotationUtils.getAnnotation(anns, PathParam.class);
        if (pathParam != null) {
            return JAXRSUtils.readFromUriParam(pathParam, parameterClass, genericParam, path, values, defaultValue, !isEncoded);
        }
        QueryParam qp = AnnotationUtils.getAnnotation(anns, QueryParam.class);
        if (qp != null) {
            return JAXRSUtils.readQueryString(qp, parameterClass, genericParam, message, defaultValue, !isEncoded);
        }
        MatrixParam mp = AnnotationUtils.getAnnotation(anns, MatrixParam.class);
        if (mp != null) {
            return JAXRSUtils.processMatrixParam(message, mp.value(), parameterClass, genericParam, defaultValue, !isEncoded);
        }
        CookieParam cookie = AnnotationUtils.getAnnotation(anns, CookieParam.class);
        if (cookie != null) {
            return JAXRSUtils.processCookieParam(message, cookie.value(), parameterClass, genericParam, defaultValue);
        }
        HeaderParam hp = AnnotationUtils.getAnnotation(anns, HeaderParam.class);
        if (hp != null) {
            return JAXRSUtils.processHeaderParam(message, hp.value(), parameterClass, genericParam, defaultValue);
        }
        return null;
    }

    private static Object processMatrixParam(Message m, String key, Class<?> pClass, Type genericType, String defaultValue, boolean decode) {
        List<PathSegment> segments = JAXRSUtils.getPathSegments((String)m.get((Object)Message.REQUEST_URI), decode);
        if (segments.size() > 0) {
            MultivaluedMap params = segments.get(segments.size() - 1).getMatrixParameters();
            List values = (List)params.get((Object)key);
            return InjectionUtils.createParameterObject(values, pClass, genericType, defaultValue, false, false);
        }
        return null;
    }

    public static MultivaluedMap<String, String> getMatrixParams(String path, boolean decode) {
        int index = path.indexOf(59);
        return index == -1 ? new MetadataMap<String, String>() : JAXRSUtils.getStructuredParams(path.substring(index + 1), ";", decode);
    }

    private static Object processHeaderParam(Message m, String header, Class<?> pClass, Type genericType, String defaultValue) {
        Map headers = (Map)m.get((Object)Message.PROTOCOL_HEADERS);
        List values = (List)headers.get(header);
        StringBuilder sb = new StringBuilder();
        if (values != null) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
        }
        return sb.length() > 0 ? InjectionUtils.handleParameter(sb.toString(), pClass) : defaultValue;
    }

    private static Object processCookieParam(Message m, String cookieName, Class<?> pClass, Type genericType, String defaultValue) {
        Map headers = (Map)m.get((Object)Message.PROTOCOL_HEADERS);
        List values = (List)headers.get("Cookie");
        String value = "";
        if (values != null && ((String)values.get(0)).contains(cookieName + '=')) {
            value = (String)values.get(0);
        }
        if (pClass.isAssignableFrom(Cookie.class)) {
            return Cookie.valueOf((String)(value.length() == 0 ? defaultValue : value));
        }
        return value.length() > 0 ? InjectionUtils.handleParameter(value, pClass) : defaultValue;
    }

    public static Object createContextValue(Message m, Type genericType, Class<?> clazz) {
        ContextResolver<?> o = null;
        if (UriInfo.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createUriInfo(m);
        } else if (HttpHeaders.class.isAssignableFrom(clazz)) {
            o = new HttpHeadersImpl(m);
        } else if (Request.class.isAssignableFrom(clazz)) {
            o = new RequestImpl(m);
        } else if (SecurityContext.class.isAssignableFrom(clazz)) {
            o = new SecurityContextImpl(m);
        } else if (MessageBodyWorkers.class.isAssignableFrom(clazz)) {
            o = new MessageBodyWorkersImpl(m);
        } else if (ContextResolver.class.isAssignableFrom(clazz)) {
            o = JAXRSUtils.createContextResolver(genericType, m);
        }
        return o == null ? JAXRSUtils.createServletResourceValue(m, clazz) : o;
    }

    private static UriInfo createUriInfo(Message m) {
        MultivaluedMap templateParams = (MultivaluedMap)m.get((Object)"jaxrs.template.parameters");
        return new UriInfoImpl(m, (MultivaluedMap<String, String>)templateParams);
    }

    public static ContextResolver<?> createContextResolver(Type genericType, Message m) {
        if (genericType instanceof ParameterizedType) {
            return ProviderFactory.getInstance().createContextResolver(((ParameterizedType)genericType).getActualTypeArguments()[0], m);
        }
        return null;
    }

    public static Object createResourceValue(Message m, Class<?> clazz) {
        return JAXRSUtils.createServletResourceValue(m, clazz);
    }

    private static Object createServletResourceValue(Message m, Class<?> clazz) {
        if (HttpServletRequest.class.isAssignableFrom(clazz)) {
            return (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
        }
        if (HttpServletResponse.class.isAssignableFrom(clazz)) {
            return (HttpServletResponse)m.get((Object)"HTTP.RESPONSE");
        }
        if (ServletContext.class.isAssignableFrom(clazz)) {
            return (ServletContext)m.get((Object)"HTTP.CONTEXT");
        }
        return null;
    }

    private static Object readFromUriParam(PathParam uriParamAnnotation, Class<?> paramType, Type genericType, String path, MultivaluedMap<String, String> values, String defaultValue, boolean decoded) {
        String parameterName = uriParamAnnotation.value();
        if ("".equals(parameterName)) {
            return InjectionUtils.handleBean(paramType, values);
        }
        List results = (List)values.get((Object)parameterName);
        return InjectionUtils.createParameterObject(results, paramType, genericType, defaultValue, true, decoded);
    }

    private static Object readQueryString(QueryParam queryParam, Class<?> paramType, Type genericType, Message m, String defaultValue, boolean decode) {
        String queryName = queryParam.value();
        if ("".equals(queryName)) {
            return InjectionUtils.handleBean(paramType, new UriInfoImpl(m, null).getQueryParameters());
        }
        List results = (List)JAXRSUtils.getStructuredParams((String)m.get((Object)Message.QUERY_STRING), "&", decode).get((Object)queryName);
        return InjectionUtils.createParameterObject(results, paramType, genericType, defaultValue, false, false);
    }

    public static MultivaluedMap<String, String> getStructuredParams(String query, String sep, boolean decode) {
        MetadataMap<String, String> queries = new MetadataMap<String, String>(new LinkedHashMap());
        if (!StringUtils.isEmpty((String)query)) {
            List<String> parts = Arrays.asList(query.split(sep));
            for (String part : parts) {
                String[] values = part.split("=");
                queries.add(values[0], values.length == 1 ? "" : (decode ? JAXRSUtils.uriDecode(values[1]) : values[1]));
            }
        }
        return queries;
    }

    public static String uriDecode(String query) {
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return query;
    }

    private static <T> Object readFromMessageBody(Class<T> targetTypeClass, Type parameterType, Annotation[] parameterAnnotations, InputStream is, MediaType contentType, List<MediaType> consumeTypes, Message m) {
        List<MediaType> types = JAXRSUtils.intersectMimeTypes(consumeTypes, contentType);
        MessageBodyReader<T> provider = null;
        Iterator<MediaType> i$ = types.iterator();
        if (i$.hasNext()) {
            MediaType type = i$.next();
            provider = ProviderFactory.getInstance().createMessageBodyReader(targetTypeClass, parameterType, parameterAnnotations, type, m);
            if (provider != null) {
                try {
                    HttpHeadersImpl headers = new HttpHeadersImpl(m);
                    return provider.readFrom(targetTypeClass, parameterType, parameterAnnotations, contentType, headers.getRequestHeaders(), is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error deserializing input stream into target class " + targetTypeClass.getSimpleName() + ", content type : " + contentType);
                }
            }
            throw new RuntimeException("No message body reader found for target class " + targetTypeClass.getSimpleName() + ", content type : " + contentType);
        }
        return null;
    }

    public static boolean matchMimeTypes(MediaType requestContentType, MediaType acceptContentType, OperationResourceInfo ori) {
        return JAXRSUtils.intersectMimeTypes(ori.getConsumeTypes(), requestContentType).size() != 0 && JAXRSUtils.intersectMimeTypes(ori.getProduceTypes(), acceptContentType).size() != 0;
    }

    public static List<MediaType> parseMediaTypes(String types) {
        ArrayList<MediaType> acceptValues = new ArrayList<MediaType>();
        if (types != null) {
            while (types.length() > 0) {
                String tp = types;
                int index = types.indexOf(44);
                if (index != -1) {
                    tp = types.substring(0, index);
                    types = types.substring(index + 1).trim();
                } else {
                    types = "";
                }
                acceptValues.add(MediaType.valueOf((String)tp));
            }
        } else {
            acceptValues.add(ALL_TYPES);
        }
        return acceptValues;
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> requiredMediaTypes, List<MediaType> userMediaTypes) {
        LinkedHashSet<MediaType> supportedMimeTypeList = new LinkedHashSet<MediaType>();
        for (MediaType requiredType : requiredMediaTypes) {
            for (MediaType userType : userMediaTypes) {
                if (!requiredType.isCompatible(userType) && !userType.isCompatible(requiredType)) continue;
                for (Map.Entry entry : userType.getParameters().entrySet()) {
                    String value = (String)requiredType.getParameters().get(entry.getKey());
                    if (value != null && value.equals(entry.getValue())) continue;
                }
                String type = requiredType.getType().equals("*") ? userType.getType() : requiredType.getType();
                String subtype = requiredType.getSubtype().equals("*") ? userType.getSubtype() : requiredType.getSubtype();
                supportedMimeTypeList.add(new MediaType(type, subtype, userType.getParameters()));
            }
        }
        return new ArrayList<MediaType>(supportedMimeTypeList);
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> mimeTypesA, MediaType mimeTypeB) {
        return JAXRSUtils.intersectMimeTypes(mimeTypesA, Collections.singletonList(mimeTypeB));
    }

    public static List<MediaType> intersectMimeTypes(String mimeTypesA, String mimeTypesB) {
        return JAXRSUtils.intersectMimeTypes(JAXRSUtils.parseMediaTypes(mimeTypesA), JAXRSUtils.parseMediaTypes(mimeTypesB));
    }

    public static List<MediaType> sortMediaTypes(String mediaTypes) {
        return JAXRSUtils.sortMediaTypes(JAXRSUtils.parseMediaTypes(mediaTypes));
    }

    public static List<MediaType> sortMediaTypes(List<MediaType> types) {
        if (types.size() > 1) {
            Collections.sort(types, new Comparator<MediaType>(){

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    return JAXRSUtils.compareMediaTypes(mt1, mt2);
                }
            });
        }
        return types;
    }

    private static <K, V> MultivaluedMap<K, V> cloneMap(MultivaluedMap<K, V> map1) {
        MetadataMap map2 = new MetadataMap();
        for (Map.Entry entry : map1.entrySet()) {
            map2.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return map2;
    }

    public static Response convertFaultToResponse(Throwable ex) {
        ExceptionMapper mapper = ProviderFactory.getInstance().createExceptionMapper(ex.getClass(), (Message)new MessageImpl());
        if (mapper != null) {
            Response excResponse = mapper.toResponse((Object)ex);
            if (excResponse != null) {
                return excResponse;
            }
        } else if (ex instanceof WebApplicationException) {
            WebApplicationException wex = (WebApplicationException)ex;
            return wex.getResponse();
        }
        return null;
    }
}

