/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;

public class SAAJOutInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SAAJOutInterceptor.class);
    private static final String ORIGINAL_XML_WRITER = SAAJOutInterceptor.class.getName() + ".original.xml.writer";

    public SAAJOutInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SOAPMessage saaj = (SOAPMessage)message.getContent(SOAPMessage.class);
        if (saaj == null) {
            SoapVersion version = message.getVersion();
            try {
                MessageFactory factory = null;
                factory = version.getVersion() == 1.1 ? MessageFactory.newInstance() : MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
                SOAPMessage soapMessage = factory.createMessage();
                SOAPPart soapPart = soapMessage.getSOAPPart();
                XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
                message.put(ORIGINAL_XML_WRITER, origWriter);
                W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Document)soapPart);
                message.setContent(XMLStreamWriter.class, writer);
                message.setContent(SOAPMessage.class, soapMessage);
            }
            catch (SOAPException e) {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPEXCEPTION", BUNDLE, new Object[0]), (Throwable)e, version.getSender());
            }
        }
        try {
            XMLStreamWriter origWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
            message.put(ORIGINAL_XML_WRITER, origWriter);
            XMLStreamWriter dummyWriter = StaxUtils.getXMLOutputFactory().createXMLStreamWriter(new ByteArrayOutputStream());
            message.setContent(XMLStreamWriter.class, dummyWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        message.getInterceptorChain().add((Interceptor)new SAAJOutEndingInterceptor());
    }

    public void handleFault(SoapMessage message) {
        super.handleFault((Message)message);
        XMLStreamWriter writer = (XMLStreamWriter)message.get(ORIGINAL_XML_WRITER);
        if (writer != null) {
            message.setContent(XMLStreamWriter.class, writer);
        }
    }

    public class SAAJOutEndingInterceptor
    extends AbstractSoapInterceptor {
        public SAAJOutEndingInterceptor() {
            super(SAAJOutEndingInterceptor.class.getName(), "pre-protocol-ending");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
            if (soapMessage != null) {
                if (soapMessage.countAttachments() > 0) {
                    if (message.getAttachments() == null) {
                        message.setAttachments(new ArrayList(soapMessage.countAttachments()));
                    }
                    Iterator it = CastUtils.cast((Iterator)soapMessage.getAttachments());
                    while (it.hasNext()) {
                        AttachmentPart part = (AttachmentPart)it.next();
                        AttachmentImpl att = new AttachmentImpl(part.getContentId());
                        try {
                            att.setDataHandler(part.getDataHandler());
                        }
                        catch (SOAPException e) {
                            throw new Fault((Throwable)e);
                        }
                        Iterator it2 = CastUtils.cast((Iterator)part.getAllMimeHeaders());
                        while (it2.hasNext()) {
                            MimeHeader header = (MimeHeader)it2.next();
                            att.setHeader(header.getName(), header.getValue());
                        }
                        message.getAttachments().add(att);
                    }
                }
                XMLStreamWriter writer = (XMLStreamWriter)message.get(ORIGINAL_XML_WRITER);
                try {
                    StaxUtils.copy((XMLStreamReader)new W3CDOMStreamReader((Document)soapMessage.getSOAPPart()), (XMLStreamWriter)writer);
                    writer.flush();
                    message.setContent(XMLStreamWriter.class, writer);
                }
                catch (XMLStreamException e) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPEXCEPTION", BUNDLE, new Object[0]), (Throwable)e, message.getVersion().getSender());
                }
            }
        }
    }
}

