/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaElement;

public class NamespacePrefixAccumulator {
    private StringBuffer attributes = new StringBuffer();
    private Set<String> prefixes = new HashSet<String>();
    private Map<String, String> fallbackNamespacePrefixMap = new HashMap<String, String>();
    private int nsCounter = 0;
    private SchemaCollection schemaCollection;

    public NamespacePrefixAccumulator(SchemaCollection schemaCollection) {
        this.schemaCollection = schemaCollection;
    }

    public void collect(String prefix, String uri) {
        if (!"".equals(uri) && !this.prefixes.contains(prefix)) {
            this.attributes.append("xmlns:" + prefix + "='" + uri + "' ");
            this.prefixes.add(prefix);
        }
    }

    public String getAttributes() {
        return this.attributes.toString();
    }

    private String getPrefix(String namespaceURI) {
        if ("".equals(namespaceURI)) {
            throw new RuntimeException("Prefix requested for default namespace.");
        }
        String schemaPrefix = this.schemaCollection.getNamespaceContext().getPrefix(namespaceURI);
        if ((schemaPrefix == null || "tns".equals(schemaPrefix)) && (schemaPrefix = this.fallbackNamespacePrefixMap.get(namespaceURI)) == null) {
            schemaPrefix = "jns" + this.nsCounter;
            ++this.nsCounter;
            this.fallbackNamespacePrefixMap.put(namespaceURI, schemaPrefix);
        }
        return schemaPrefix;
    }

    public String xmlElementString(XmlSchemaElement element, boolean qualified) {
        if (qualified) {
            String prefix = this.getPrefix(element.getQName().getNamespaceURI());
            this.collect(prefix, element.getQName().getNamespaceURI());
            return prefix + ":" + element.getName();
        }
        return element.getName();
    }

    public String xmlAttributeString(XmlSchemaAttribute attribute, boolean qualified) {
        if (qualified) {
            String prefix = this.getPrefix(attribute.getQName().getNamespaceURI());
            this.collect(prefix, attribute.getQName().getNamespaceURI());
            return prefix + ":" + attribute.getName();
        }
        return attribute.getName();
    }

    public String xmlElementString(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return name.getLocalPart();
        }
        String prefix = this.getPrefix(name.getNamespaceURI());
        this.collect(prefix, name.getNamespaceURI());
        return prefix + ":" + name.getLocalPart();
    }
}

