/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String RELATIVE_PATH = "relative.path";
    public static final String ROOT_RESOURCE_CLASS = "root.resource.class";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInInterceptor.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInInterceptor.class);

    public JAXRSInInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) {
        try {
            this.processRequest(message);
        }
        catch (RuntimeException ex) {
            Response excResponse = JAXRSUtils.convertFaultToResponse(ex);
            if (excResponse == null) {
                ProviderFactory.getInstance().cleatThreadLocalProxies();
                throw ex;
            }
            message.getExchange().put(Response.class, (Object)excResponse);
        }
    }

    private static String updatePath(String path, String address) {
        if (path.startsWith(address) && !(path = path.substring(address.length())).startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private void processRequest(Message message) {
        int idx;
        RequestPreprocessor rp = ProviderFactory.getInstance().getRequestPreprocessor();
        if (rp != null) {
            rp.preprocess(message, new UriInfoImpl(message, null));
        }
        String path = (String)message.get((Object)Message.REQUEST_URI);
        String address = (String)message.get((Object)Message.BASE_PATH);
        String httpMethod = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        String requestContentType = (String)message.get((Object)"Content-Type");
        if (requestContentType == null) {
            requestContentType = "*/*";
        }
        if (address.startsWith("http") && (idx = address.indexOf(47, 7)) != -1) {
            address = address.substring(idx);
        }
        path = JAXRSInInterceptor.updatePath(path, address);
        Service service = (Service)message.getExchange().get(Service.class);
        List<ClassResourceInfo> resources = ((JAXRSServiceImpl)service).getClassResourceInfos();
        String acceptTypes = (String)message.get((Object)"Accept");
        if (acceptTypes == null) {
            acceptTypes = "*/*";
            message.put((Object)"Accept", (Object)acceptTypes);
        }
        List<MediaType> acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes);
        message.getExchange().put((Object)"Accept", acceptContentTypes);
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        ClassResourceInfo resource = JAXRSUtils.selectResourceClass(resources, path, values);
        if (resource == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_ROOT_EXC", BUNDLE, new Object[]{path});
            LOG.severe(errorMsg.toString());
            throw new WebApplicationException(404);
        }
        message.getExchange().put((Object)ROOT_RESOURCE_CLASS, (Object)resource);
        OperationResourceInfo ori = null;
        List<ProviderInfo<RequestHandler>> shs = ProviderFactory.getInstance().getRequestHandlers();
        for (ProviderInfo<RequestHandler> sh : shs) {
            Response response;
            String newAcceptTypes = (String)message.get((Object)"Accept");
            if (!acceptTypes.equals(newAcceptTypes) || ori == null) {
                acceptTypes = newAcceptTypes;
                acceptContentTypes = JAXRSUtils.sortMediaTypes(newAcceptTypes);
                message.getExchange().put((Object)"Accept", acceptContentTypes);
                if (ori != null) {
                    values = new MetadataMap();
                    resource = JAXRSUtils.selectResourceClass(resources, path, values);
                }
                ori = JAXRSUtils.findTargetMethod(resource, (String)values.getFirst("FINAL_MATCH_GROUP"), httpMethod, values, requestContentType, acceptContentTypes);
                message.getExchange().put(OperationResourceInfo.class, (Object)ori);
            }
            if ((response = sh.getProvider().handleRequest(message, resource)) == null) continue;
            message.getExchange().put(Response.class, (Object)response);
            return;
        }
        String newAcceptTypes = (String)message.get((Object)"Accept");
        if (!acceptTypes.equals(newAcceptTypes) || ori == null) {
            acceptTypes = newAcceptTypes;
            acceptContentTypes = JAXRSUtils.sortMediaTypes(acceptTypes);
            message.getExchange().put((Object)"Accept", acceptContentTypes);
            if (ori != null) {
                values = new MetadataMap();
                resource = JAXRSUtils.selectResourceClass(resources, path, values);
            }
            ori = JAXRSUtils.findTargetMethod(resource, (String)values.getFirst("FINAL_MATCH_GROUP"), httpMethod, values, requestContentType, acceptContentTypes);
            message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        }
        LOG.fine("Request path is: " + path);
        LOG.fine("Request HTTP method is: " + httpMethod);
        LOG.fine("Request contentType is: " + requestContentType);
        LOG.fine("Accept contentType is: " + acceptTypes);
        if (ori == null) {
            org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message("NO_OP_EXC", BUNDLE, new Object[]{path, requestContentType, acceptTypes});
            LOG.severe(errorMsg.toString());
            throw new Fault(errorMsg);
        }
        LOG.fine("Found operation: " + ori.getMethodToInvoke().getName());
        message.getExchange().put(OperationResourceInfo.class, (Object)ori);
        message.put((Object)RELATIVE_PATH, values.getFirst("FINAL_MATCH_GROUP"));
        message.put((Object)"jaxrs.template.parameters", values);
        List<Object> params = JAXRSUtils.processParameters(ori, values, message);
        message.setContent(List.class, params);
    }
}

