/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConsumeMime(value={"application/x-www-form-urlencoded"})
@Provider
public final class FormEncodingReaderProvider
implements MessageBodyReader<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return type.isAssignableFrom(MultivaluedMap.class);
    }

    public MultivaluedMap<String, String> readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            String charset = "UTF-8";
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FormEncodingReaderProvider.copy(is, bos, 1024);
            String postBody = new String(bos.toByteArray(), charset);
            MultivaluedMap<String, String> params = FormEncodingReaderProvider.getParams(postBody);
            return params;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            output.write(buffer, 0, n);
            n = input.read(buffer);
        }
    }

    protected static MultivaluedMap<String, String> getParams(String body) {
        MetadataMap<String, String> params = new MetadataMap<String, String>();
        if (!StringUtils.isEmpty((String)body)) {
            List<String> parts = Arrays.asList(body.split("&"));
            for (String part : parts) {
                String[] keyValue = part.split("=");
                if (keyValue.length == 2) {
                    params.add(keyValue[0], keyValue[1]);
                    continue;
                }
                params.add(keyValue[0], "");
            }
        }
        return params;
    }
}

