/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder {
    private String scheme;
    private String userInfo;
    private int port;
    private String host;
    private List<PathSegment> paths;
    private String fragment;
    private MultivaluedMap<String, String> query = new MetadataMap<String, String>();
    private MultivaluedMap<String, String> matrix = new MetadataMap<String, String>();

    public UriBuilderImpl() {
    }

    public UriBuilderImpl(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
    }

    public URI build() throws UriBuilderException {
        try {
            return new URI(this.scheme, this.userInfo, this.host, this.port, this.buildPath(), this.buildQuery(), this.fragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    public URI build(Map<String, Object> map) throws IllegalArgumentException, UriBuilderException {
        try {
            String path = this.buildPath();
            path = this.substituteMapped(path, map);
            return new URI(this.scheme, this.userInfo, this.host, this.port, path, this.buildQuery(), this.fragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        try {
            String path = this.buildPath();
            path = this.substituteVarargs(path, values);
            return new URI(this.scheme, this.userInfo, this.host, this.port, path, this.buildQuery(), this.fragment);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException("URI can not be built", (Throwable)ex);
        }
    }

    private String substituteVarargs(String path, Object ... values) {
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        URITemplate templ = new URITemplate(path);
        LinkedHashSet<String> uniqueVars = new LinkedHashSet<String>(templ.getVariables());
        if (values.length < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + values.length + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        int idx = 0;
        for (String var : uniqueVars) {
            Object oval = values[idx++];
            varValueMap.put(var, oval.toString());
        }
        return templ.substitute(varValueMap);
    }

    private String substituteMapped(String path, Map<String, ? extends Object> varValueMap) {
        URITemplate templ = new URITemplate(path);
        HashSet<String> uniqueVars = new HashSet<String>(templ.getVariables());
        if (varValueMap.size() < uniqueVars.size()) {
            throw new IllegalArgumentException("Unresolved variables; only " + varValueMap.size() + " value(s) given for " + uniqueVars.size() + " unique variable(s)");
        }
        return templ.substitute(varValueMap);
    }

    public UriBuilder clone() {
        return new UriBuilderImpl(this.build());
    }

    public UriBuilder encode(boolean enable) {
        return this;
    }

    public UriBuilder fragment(String theFragment) throws IllegalArgumentException {
        this.fragment = theFragment;
        return this;
    }

    public UriBuilder host(String theHost) throws IllegalArgumentException {
        this.host = theHost;
        return this;
    }

    public UriBuilder matrixParam(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value != null) {
            this.matrix.add((Object)name, (Object)value);
        } else {
            this.matrix.remove((Object)name);
        }
        return this;
    }

    public UriBuilder path(String ... segments) throws IllegalArgumentException {
        if (this.paths == null) {
            this.paths = new ArrayList<PathSegment>();
        }
        for (String seg : segments) {
            this.paths.addAll(JAXRSUtils.getPathSegments(seg, false));
        }
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        Path ann = resource.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Class '" + resource.getCanonicalName() + "' is not annotated with Path");
        }
        return this.path(ann.value());
    }

    public UriBuilder path(Method ... methods) throws IllegalArgumentException {
        if (methods == null) {
            throw new IllegalArgumentException("methods is null");
        }
        for (Method method : methods) {
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            Path ann = method.getAnnotation(Path.class);
            if (ann == null) {
                throw new IllegalArgumentException("Method '" + method.getClass().getCanonicalName() + "." + method.getName() + "' is not annotated with Path");
            }
            this.path(ann.value());
        }
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path foundAnn = null;
        for (Method meth : resource.getMethods()) {
            if (!meth.getName().equals(method)) continue;
            Path ann = meth.getAnnotation(Path.class);
            if (foundAnn != null && ann != null) {
                throw new IllegalArgumentException("Multiple Path annotations for '" + method + "' overloaded method");
            }
            foundAnn = ann;
        }
        if (foundAnn == null) {
            throw new IllegalArgumentException("No Path annotation for '" + method + "' method");
        }
        return this.path(((Path)foundAnn).value());
    }

    public UriBuilder port(int thePort) throws IllegalArgumentException {
        this.port = thePort;
        return this;
    }

    public UriBuilder queryParam(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value != null) {
            this.query.add((Object)name, (Object)value);
        } else {
            this.query.remove((Object)name);
        }
        return this;
    }

    public UriBuilder replaceMatrixParams(String m) throws IllegalArgumentException {
        if (m == null) {
            throw new IllegalArgumentException("name is null");
        }
        MultivaluedMap<String, String> values = JAXRSUtils.getStructuredParams(m, ";", true);
        for (Map.Entry entry : values.entrySet()) {
            this.matrix.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UriBuilder replaceQueryParams(String q) throws IllegalArgumentException {
        if (q == null) {
            throw new IllegalArgumentException("name is null");
        }
        MultivaluedMap<String, String> values = JAXRSUtils.getStructuredParams(q, "&", true);
        for (Map.Entry entry : values.entrySet()) {
            this.query.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public UriBuilder scheme(String s) throws IllegalArgumentException {
        this.scheme = s;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        try {
            URI uri = new URI("whatever://" + ssp);
            this.port = uri.getPort();
            this.host = uri.getHost();
            this.paths = JAXRSUtils.getPathSegments(uri.getPath(), false);
            this.fragment = uri.getFragment();
            this.query = JAXRSUtils.getStructuredParams(uri.getQuery(), "&", true);
            this.userInfo = uri.getUserInfo();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Wrong syntax of scheme-specific part", e);
        }
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        this.setUriParts(uri);
        return this;
    }

    public UriBuilder userInfo(String ui) throws IllegalArgumentException {
        this.userInfo = ui;
        return this;
    }

    public boolean isEncode() {
        throw new UnsupportedOperationException("Not implemented :/");
    }

    public UriBuilder extension(String arg0) {
        throw new UnsupportedOperationException("Not implemented :/");
    }

    public UriBuilder replacePath(String ... path) throws IllegalArgumentException {
        for (String p : path) {
            this.paths = JAXRSUtils.getPathSegments(p, false);
        }
        return this;
    }

    private void setUriParts(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.scheme = uri.getScheme();
        this.port = uri.getPort();
        this.host = uri.getHost();
        this.paths = JAXRSUtils.getPathSegments(uri.getPath(), false);
        if (!this.paths.isEmpty()) {
            this.matrix = this.paths.get(this.paths.size() - 1).getMatrixParameters();
        }
        this.fragment = uri.getFragment();
        this.query = JAXRSUtils.getStructuredParams(uri.getQuery(), "&", true);
        this.userInfo = uri.getUserInfo();
    }

    private String buildPath() {
        StringBuilder sb = new StringBuilder();
        Iterator<PathSegment> iter = this.paths.iterator();
        while (iter.hasNext()) {
            String p = iter.next().getPath();
            if (p.length() == 0 && iter.hasNext()) continue;
            if (!p.startsWith("/")) {
                sb.append('/');
            }
            sb.append(p);
        }
        if (!this.matrix.isEmpty()) {
            sb.append(';');
            sb.append(this.buildParams(this.matrix, ';'));
        }
        return sb.toString();
    }

    private String buildQuery() {
        return this.buildParams(this.query, '&');
    }

    private String buildParams(MultivaluedMap<String, String> map, char separator) {
        StringBuilder b = new StringBuilder();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Iterator sit = ((List)entry.getValue()).iterator();
            while (sit.hasNext()) {
                String val = (String)sit.next();
                b.append((String)entry.getKey()).append('=').append(val);
                if (!sit.hasNext() && !it.hasNext()) continue;
                b.append(separator);
            }
        }
        return b.length() > 0 ? b.toString() : null;
    }
}

